/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.visitor.CommandPartVisitor;
import me.fixeddev.commandflow.stack.ArgumentStack;
import me.fixeddev.commandflow.stack.StackSnapshot;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import org.jetbrains.annotations.Nullable;

public interface ArgumentPart
extends CommandPart {
    @Override
    @Nullable
    default public Component getLineRepresentation() {
        return TextComponent.builder("<" + this.getName() + ">").build();
    }

    @Override
    default public void parse(CommandContext context, ArgumentStack stack, CommandPart caller) throws ArgumentParseException {
        StackSnapshot snapshot = stack.getSnapshot();
        int oldArgumentsLeft = stack.getArgumentsLeft();
        List<?> value = this.parseValue(context, stack, caller);
        ArrayList<String> rawArgs = new ArrayList<String>();
        int usedArguments = oldArgumentsLeft - stack.getArgumentsLeft();
        if (usedArguments != 0) {
            stack.applySnapshot(snapshot);
            for (int i = 0; i < usedArguments; ++i) {
                rawArgs.add(stack.next());
            }
        }
        context.setValues(this, value);
        context.setRaw(this, rawArgs);
    }

    @Override
    default public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        if (stack.hasNext()) {
            stack.next();
        }
        return Collections.emptyList();
    }

    @Override
    default public <T> T acceptVisitor(CommandPartVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public List<?> parseValue(CommandContext var1, ArgumentStack var2, CommandPart var3) throws ArgumentParseException;
}

