/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.fixeddev.commandflow.command.Command;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.defaults.BooleanPart;
import me.fixeddev.commandflow.part.defaults.DoublePart;
import me.fixeddev.commandflow.part.defaults.EnumPart;
import me.fixeddev.commandflow.part.defaults.FirstMatchPart;
import me.fixeddev.commandflow.part.defaults.FloatPart;
import me.fixeddev.commandflow.part.defaults.IntegerPart;
import me.fixeddev.commandflow.part.defaults.LimitingPart;
import me.fixeddev.commandflow.part.defaults.LongPart;
import me.fixeddev.commandflow.part.defaults.OptionalPart;
import me.fixeddev.commandflow.part.defaults.SequentialCommandPart;
import me.fixeddev.commandflow.part.defaults.StringPart;
import me.fixeddev.commandflow.part.defaults.SubCommandPart;
import me.fixeddev.commandflow.part.defaults.SwitchPart;
import me.fixeddev.commandflow.part.defaults.ValueFlagPart;

public final class Parts {
    public static CommandPart limit(CommandPart part, int limit) {
        return new LimitingPart(part, limit);
    }

    public static CommandPart switchPart(String shortName) {
        return Parts.switchPart(shortName, shortName);
    }

    public static CommandPart switchPart(String name, String shortName) {
        return Parts.switchPart(name, shortName, false);
    }

    public static CommandPart switchPart(String name, String shortName, boolean allowFullNameUse) {
        return new SwitchPart(name, shortName, allowFullNameUse);
    }

    public static CommandPart valueFlag(CommandPart part, String shortName) {
        return Parts.valueFlag(part, shortName, false);
    }

    public static CommandPart valueFlag(CommandPart part, String shortName, boolean allowFullNameUse) {
        return new ValueFlagPart(shortName, allowFullNameUse, part);
    }

    public static CommandPart enumPart(String name, Class<? extends Enum<?>> enumType) {
        return new EnumPart(name, enumType);
    }

    public static CommandPart string(String name) {
        return new StringPart(name);
    }

    public static CommandPart longPart(String name) {
        return new LongPart(name);
    }

    public static CommandPart longPart(String name, long min, long max) {
        return new LongPart(name, min, max);
    }

    public static CommandPart integer(String name) {
        return new IntegerPart(name);
    }

    public static CommandPart integer(String name, int min, int max) {
        return new IntegerPart(name, min, max);
    }

    public static CommandPart doublePart(String name) {
        return new DoublePart(name);
    }

    public static CommandPart doublePart(String name, double min, double max) {
        return new DoublePart(name, min, max);
    }

    public static CommandPart floatPart(String name) {
        return new FloatPart(name);
    }

    public static CommandPart floatPart(String name, float min, float max) {
        return new FloatPart(name, min, max);
    }

    public static CommandPart booleanPart(String name) {
        return new BooleanPart(name);
    }

    public static CommandPart firstMatch(String name, CommandPart ... parts) {
        return new FirstMatchPart(name, Arrays.asList(parts));
    }

    public static CommandPart firstMatch(String name, Collection<CommandPart> parts) {
        return new FirstMatchPart(name, new ArrayList<CommandPart>(parts));
    }

    public static CommandPart sequential(String name, CommandPart ... parts) {
        return new SequentialCommandPart(name, Arrays.asList(parts));
    }

    public static CommandPart sequential(String name, Collection<CommandPart> parts) {
        return new SequentialCommandPart(name, new ArrayList<CommandPart>(parts));
    }

    public static CommandPart subCommand(String name, Command ... commands) {
        return new SubCommandPart(name, Arrays.asList(commands));
    }

    public static CommandPart subCommand(String name, Collection<Command> commands) {
        return new SubCommandPart(name, new ArrayList<Command>(commands));
    }

    public static CommandPart subCommand(String name, Collection<Command> commands, boolean optional) {
        return new SubCommandPart(name, new ArrayList<Command>(commands), optional);
    }

    public static CommandPart subCommand(Collection<Command> commands) {
        return new SubCommandPart("subcommand", new ArrayList<Command>(commands));
    }

    public static CommandPart subCommand(Command ... commands) {
        return new SubCommandPart("subcommand", Arrays.asList(commands));
    }

    public static CommandPart optional(CommandPart part) {
        return new OptionalPart(part);
    }

    public static CommandPart optional(CommandPart part, List<String> defaultValues) {
        return new OptionalPart(part, defaultValues);
    }

    public static CommandPart strictOptional(CommandPart part) {
        return new OptionalPart(part, false);
    }

    public static CommandPart strictOptional(CommandPart part, List<String> defaultValues) {
        return new OptionalPart(part, false, defaultValues);
    }
}

