/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.visitor.CommandPartVisitor;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.Component;
import org.jetbrains.annotations.Nullable;

public class ArgumentRewriterPart
implements CommandPart {
    private final CommandPart delegatePart;
    private final Map<String, String> rewrites;

    public ArgumentRewriterPart(CommandPart delegatePart) {
        this.delegatePart = delegatePart;
        this.rewrites = new HashMap<String, String>();
    }

    @Override
    public String getName() {
        return this.delegatePart.getName();
    }

    @Override
    public void parse(CommandContext context, ArgumentStack stack, @Nullable CommandPart caller) throws ArgumentParseException {
        String next = stack.next();
        int position = stack.getPosition();
        String to = this.rewrites.get(next);
        if (to != null) {
            stack.getBacking().set(position, to);
        }
        this.delegatePart.parse(context, stack, caller);
    }

    @Override
    @Nullable
    public Component getLineRepresentation() {
        return this.delegatePart.getLineRepresentation();
    }

    @Override
    @Nullable
    public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        return this.delegatePart.getSuggestions(commandContext, stack);
    }

    @Override
    public boolean isAsync() {
        return this.delegatePart.isAsync();
    }

    @Override
    public <T> T acceptVisitor(CommandPartVisitor<T> visitor) {
        return this.delegatePart.acceptVisitor(visitor);
    }

    public void addRewrite(String to, String ... from) {
        for (String fromStr : from) {
            this.rewrites.put(fromStr, to);
        }
    }

    public void removeRewrite(String to, String ... from) {
        for (String fromStr : from) {
            this.rewrites.remove(fromStr, to);
        }
    }
}

