/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.Collections;
import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.defaults.PrimitivePart;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;

public class DoublePart
extends PrimitivePart {
    private final double max;
    private final double min;
    private final boolean ranged;

    public DoublePart(String name) {
        this(name, 0.0, 0.0, false);
    }

    public DoublePart(String name, double min, double max) {
        this(name, min, max, true);
    }

    private DoublePart(String name, double min, double max, boolean ranged) {
        super(name);
        this.max = max;
        this.min = min;
        this.ranged = ranged;
    }

    public List<Double> parseValue(CommandContext context, ArgumentStack stack, CommandPart parent) throws ArgumentParseException {
        double next = stack.nextDouble();
        if (this.ranged && (next > this.max || next < this.min)) {
            TranslatableComponent message = TranslatableComponent.of("number.out-range", TextComponent.of(next), TextComponent.of(this.min), TextComponent.of(this.max));
            throw new ArgumentParseException(message);
        }
        return Collections.singletonList(next);
    }
}

