/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.ContextSnapshot;
import me.fixeddev.commandflow.exception.ArgumentException;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.PartsWrapper;
import me.fixeddev.commandflow.stack.ArgumentStack;
import me.fixeddev.commandflow.stack.StackSnapshot;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import org.jetbrains.annotations.Nullable;

public class FirstMatchPart
implements CommandPart,
PartsWrapper {
    private final String name;
    private final List<CommandPart> partList;
    private Boolean async;
    private final boolean considerNoChangesAsFail;

    public FirstMatchPart(String name, List<CommandPart> partList, boolean considerNoChangesAsFail) {
        this.name = name;
        this.partList = partList;
        this.considerNoChangesAsFail = considerNoChangesAsFail;
    }

    public FirstMatchPart(String name, List<CommandPart> partList) {
        this(name, partList, true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Component getLineRepresentation() {
        TextComponent component = TextComponent.of("<");
        boolean first = true;
        for (CommandPart part : this.partList) {
            Component partComponent = part.getLineRepresentation();
            if (partComponent == null) continue;
            if (first) {
                first = false;
            } else {
                component = (TextComponent)component.append(TextComponent.of("|"));
            }
            component = (TextComponent)component.append(partComponent);
        }
        component = (TextComponent)component.append(TextComponent.of(">"));
        return component;
    }

    @Override
    public void parse(CommandContext context, ArgumentStack stack, CommandPart caller) throws ArgumentParseException {
        ArgumentException last = null;
        Iterator<CommandPart> partIterator = this.partList.iterator();
        while (partIterator.hasNext()) {
            CommandPart part = partIterator.next();
            ContextSnapshot contextSnapshot = context.getSnapshot();
            StackSnapshot snapshot = stack.getSnapshot();
            try {
                part.parse(context, stack, this);
                if (!this.considerNoChangesAsFail) {
                    return;
                }
                ContextSnapshot newState = context.getSnapshot();
                StackSnapshot newStackState = stack.getSnapshot();
                if (newState.equals(contextSnapshot) && newStackState.equals(snapshot) && !partIterator.hasNext()) {
                    if (last == null) {
                        last = new ArgumentParseException("");
                    }
                    throw last;
                }
                return;
            }
            catch (ArgumentException e) {
                if (partIterator.hasNext()) {
                    stack.applySnapshot(snapshot, true);
                    context.applySnapshot(contextSnapshot);
                }
                last = e;
            }
        }
        if (last != null) {
            throw last;
        }
    }

    @Override
    public List<String> getSuggestions(CommandContext context, ArgumentStack stack) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (CommandPart part : this.partList) {
            ContextSnapshot snapshot = context.getSnapshot();
            StackSnapshot stackSnapshot = stack.getSnapshot();
            List<String> partSuggestions = part.getSuggestions(context, stack);
            if (partSuggestions != null) {
                suggestions.addAll(partSuggestions);
            }
            stack.applySnapshot(stackSnapshot, true);
            context.applySnapshot(snapshot);
        }
        return suggestions;
    }

    @Override
    public boolean isAsync() {
        if (this.async == null) {
            for (CommandPart part : this.partList) {
                if (!part.isAsync()) continue;
                this.async = true;
                return this.async;
            }
            this.async = false;
            return this.async;
        }
        return this.async;
    }

    @Override
    public List<CommandPart> getParts() {
        return this.partList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FirstMatchPart)) {
            return false;
        }
        FirstMatchPart that = (FirstMatchPart)o;
        return this.name.equals(that.name) && this.partList.equals(that.partList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.partList);
    }
}

