/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.Collections;
import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.defaults.PrimitivePart;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;

public class FloatPart
extends PrimitivePart {
    private final float max;
    private final float min;
    private final boolean ranged;

    public FloatPart(String name) {
        this(name, 0.0f, 0.0f, false);
    }

    public FloatPart(String name, float min, float max) {
        this(name, min, max, true);
    }

    private FloatPart(String name, float min, float max, boolean ranged) {
        super(name);
        this.max = max;
        this.min = min;
        this.ranged = ranged;
    }

    public List<Float> parseValue(CommandContext context, ArgumentStack stack, CommandPart parent) throws ArgumentParseException {
        float next = stack.nextFloat();
        if (this.ranged && (next > this.max || next < this.min)) {
            TranslatableComponent message = TranslatableComponent.of("number.out-range", TextComponent.of(next), TextComponent.of(this.min), TextComponent.of(this.max));
            throw new ArgumentParseException(message);
        }
        return Collections.singletonList(Float.valueOf(next));
    }
}

