/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.Collections;
import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.defaults.PrimitivePart;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;

public class IntegerPart
extends PrimitivePart {
    private final int max;
    private final int min;
    private final boolean ranged;

    public IntegerPart(String name) {
        this(name, 0, 0, false);
    }

    public IntegerPart(String name, int min, int max) {
        this(name, min, max, true);
    }

    private IntegerPart(String name, int min, int max, boolean ranged) {
        super(name);
        this.max = max;
        this.min = min;
        this.ranged = ranged;
    }

    public List<Integer> parseValue(CommandContext context, ArgumentStack stack, CommandPart parent) throws ArgumentParseException {
        int next = stack.nextInt();
        if (this.ranged && (next > this.max || next < this.min)) {
            throw new ArgumentParseException(TranslatableComponent.of("number.out-range", TextComponent.of(next), TextComponent.of(this.min), TextComponent.of(this.max)));
        }
        return Collections.singletonList(next);
    }
}

