/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.SinglePartWrapper;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.Component;
import org.jetbrains.annotations.Nullable;

public class LimitingPart
implements CommandPart,
SinglePartWrapper {
    private final String name;
    private final int limit;
    private final CommandPart part;

    public LimitingPart(CommandPart part, int limit) {
        this.name = part.getName() + "-limiting";
        this.limit = limit;
        this.part = part;
        if (limit <= 0) {
            throw new IllegalArgumentException("The limit must be a positive number that's more than 0!");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Component getLineRepresentation() {
        return this.part.getLineRepresentation();
    }

    @Override
    public void parse(CommandContext context, ArgumentStack stack, CommandPart caller) throws ArgumentParseException {
        this.part.parse(context, stack.getSlice(this.limit), this);
    }

    @Override
    public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        return this.part.getSuggestions(commandContext, stack.getSlice(this.limit));
    }

    @Override
    public boolean isAsync() {
        return this.part.isAsync();
    }

    @Override
    public CommandPart getPart() {
        return this.part;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandPart)) {
            return false;
        }
        CommandPart that = (CommandPart)o;
        return that.equals(this.part);
    }
}

