/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.Collections;
import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.defaults.PrimitivePart;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;

public class LongPart
extends PrimitivePart {
    private final long max;
    private final long min;
    private final boolean ranged;

    private LongPart(String name, long min, long max, boolean ranged) {
        super(name);
        this.min = min;
        this.max = max;
        this.ranged = ranged;
    }

    public LongPart(String name, long min, long max) {
        this(name, min, max, true);
    }

    public LongPart(String name) {
        this(name, 0L, 0L, false);
    }

    public List<Long> parseValue(CommandContext context, ArgumentStack stack, CommandPart caller) throws ArgumentParseException {
        long next = stack.nextLong();
        if (this.ranged && (next > this.max || next < this.min)) {
            throw new ArgumentParseException(TranslatableComponent.of("number.out-range", TextComponent.of(next), TextComponent.of(this.min), TextComponent.of(this.max)));
        }
        return Collections.singletonList(next);
    }
}

