/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.PartsWrapper;
import me.fixeddev.commandflow.stack.ArgumentStack;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import org.jetbrains.annotations.Nullable;

public class SequentialCommandPart
implements CommandPart,
PartsWrapper {
    private final String name;
    private final List<CommandPart> parts;
    private boolean async;

    public SequentialCommandPart(String name, List<CommandPart> parts) {
        this.name = name;
        this.parts = parts;
        for (CommandPart part : parts) {
            if (!part.isAsync()) continue;
            this.async = true;
            return;
        }
    }

    @Override
    public String getName() {
        return "seq-" + this.name;
    }

    @Override
    @Nullable
    public Component getLineRepresentation() {
        TextComponent.Builder builder = TextComponent.builder("");
        boolean nonNull = false;
        for (CommandPart part : this.parts) {
            Component lineRepresentation = part.getLineRepresentation();
            if (lineRepresentation == null) continue;
            if (nonNull) {
                builder.append(TextComponent.of(" "));
            }
            builder.append(lineRepresentation);
            nonNull = true;
        }
        return nonNull ? (Component)builder.build() : null;
    }

    @Override
    public void parse(CommandContext context, ArgumentStack stack, CommandPart caller) throws ArgumentParseException {
        for (CommandPart part : this.parts) {
            part.parse(context, stack, this);
        }
    }

    @Override
    public List<String> getSuggestions(CommandContext context, ArgumentStack stack) {
        for (CommandPart part : this.parts) {
            List<String> suggestions = part.getSuggestions(context, stack);
            if (suggestions == null || stack.hasNext()) continue;
            return suggestions;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    @Override
    public List<CommandPart> getParts() {
        return this.parts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SequentialCommandPart)) {
            return false;
        }
        SequentialCommandPart that = (SequentialCommandPart)o;
        return this.name.equals(that.name) && this.parts.equals(that.parts);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parts);
    }
}

