/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.defaults.PrimitivePart;
import me.fixeddev.commandflow.stack.ArgumentStack;

public class StringPart
extends PrimitivePart {
    private final boolean consumeAll;
    private final boolean joinStrings;
    private final String separator;

    public StringPart(String name, boolean consumeAll, boolean joinStrings, String separator) {
        super(name);
        this.consumeAll = consumeAll;
        this.joinStrings = joinStrings;
        this.separator = separator;
    }

    public StringPart(String name, boolean consumeAll, boolean joinStrings) {
        this(name, consumeAll, joinStrings, " ");
    }

    public StringPart(String name, boolean consumeAll) {
        this(name, consumeAll, false);
    }

    public StringPart(String name) {
        this(name, false);
    }

    public List<String> parseValue(CommandContext context, ArgumentStack stack, CommandPart parent) throws ArgumentParseException {
        ArrayList<String> objects = new ArrayList<String>();
        String next = stack.next();
        objects.add(next);
        if (this.consumeAll) {
            while (stack.hasNext()) {
                objects.add(stack.next());
            }
            if (this.joinStrings) {
                return Collections.singletonList(String.join((CharSequence)this.separator, objects));
            }
        }
        return objects;
    }

    @Override
    public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        if (stack.hasNext()) {
            stack.next();
        }
        if (this.consumeAll) {
            while (stack.hasNext()) {
                stack.next();
            }
        }
        return Collections.emptyList();
    }

    public boolean isConsumeAll() {
        return this.consumeAll;
    }
}

