/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.part.defaults;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.fixeddev.commandflow.Authorizer;
import me.fixeddev.commandflow.CommandContext;
import me.fixeddev.commandflow.CommandManager;
import me.fixeddev.commandflow.ContextSnapshot;
import me.fixeddev.commandflow.command.Command;
import me.fixeddev.commandflow.command.modifiers.CommandModifiers;
import me.fixeddev.commandflow.command.modifiers.FallbackCommandModifiers;
import me.fixeddev.commandflow.command.modifiers.ModifierPhase;
import me.fixeddev.commandflow.exception.ArgumentException;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.exception.InvalidSubCommandException;
import me.fixeddev.commandflow.exception.NoMoreArgumentsException;
import me.fixeddev.commandflow.exception.NoPermissionsException;
import me.fixeddev.commandflow.exception.StopParseException;
import me.fixeddev.commandflow.part.CommandPart;
import me.fixeddev.commandflow.part.visitor.CommandPartVisitor;
import me.fixeddev.commandflow.stack.ArgumentStack;
import me.fixeddev.commandflow.stack.StackSnapshot;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubCommandPart
implements CommandPart {
    public static final SubCommandHandler DEFAULT_HANDLER = new DefaultSubCommandHandler();
    private final String name;
    private final Map<String, Command> subCommands;
    private final Set<Command> subCommandsSet;
    private final SubCommandHandler handler;
    private boolean optional;

    public SubCommandPart(String name, Collection<Command> subCommands, boolean optional, SubCommandHandler handler) {
        this.name = name;
        this.optional = optional;
        this.handler = handler;
        this.subCommands = new HashMap<String, Command>();
        this.subCommandsSet = new HashSet<Command>(subCommands);
        for (Command subCommand : subCommands) {
            this.subCommands.put(subCommand.getName(), subCommand);
            for (String alias : subCommand.getAliases()) {
                this.subCommands.put(alias, subCommand);
            }
        }
    }

    public SubCommandPart(String name, Collection<Command> subCommands, boolean optional) {
        this(name, subCommands, optional, DEFAULT_HANDLER);
    }

    public SubCommandPart(String name, Collection<Command> subCommands) {
        this(name, subCommands, false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Component getLineRepresentation() {
        TextComponent.Builder builder = this.isOptional() ? TextComponent.builder().content("[" + this.getName() + "]") : TextComponent.builder().content("<" + this.getName() + ">");
        return builder.build();
    }

    @Override
    public void parse(CommandContext context, ArgumentStack stack, CommandPart caller) throws ArgumentParseException {
        String label;
        try {
            label = stack.next();
        }
        catch (NoMoreArgumentsException e) {
            if (this.optional) {
                return;
            }
            throw e;
        }
        Command command = this.subCommands.get(label.toLowerCase());
        StackSnapshot snapshot = stack.getSnapshot();
        ContextSnapshot contextSnapshot = context.getSnapshot();
        try {
            context.setRaw(this, Collections.singletonList(label));
            this.handler.handle(new DefaultHandlerContext(this, context, stack), label, command);
        }
        catch (ArgumentException e) {
            if (this.optional && e instanceof InvalidSubCommandException) {
                stack.applySnapshot(snapshot);
                context.applySnapshot(contextSnapshot);
                return;
            }
            throw e;
        }
    }

    @Override
    public List<String> getSuggestions(CommandContext commandContext, ArgumentStack stack) {
        String next;
        String string = next = stack.hasNext() ? stack.next() : null;
        if (next == null) {
            return Collections.emptyList();
        }
        Command command = this.subCommands.get(next);
        ArrayList<String> suggestions = new ArrayList<String>();
        CommandManager manager = commandContext.getObject(CommandManager.class, "commandManager");
        Authorizer authorizer = manager.getAuthorizer();
        HashMap testedCommands = new HashMap();
        this.subCommands.forEach((name, subCommand) -> {
            if (name.startsWith(next) && testedCommands.computeIfAbsent(subCommand, c -> authorizer.isAuthorized(commandContext, subCommand.getPermission())).booleanValue()) {
                suggestions.add((String)name);
            }
        });
        if (stack.hasNext() && command != null) {
            return command.getPart().getSuggestions(commandContext, stack);
        }
        return suggestions;
    }

    @Override
    public <T> T acceptVisitor(CommandPartVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Map<String, Command> getSubCommandMap() {
        return this.subCommands;
    }

    public Collection<Command> getSubCommands() {
        return this.subCommandsSet;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public static class DefaultSubCommandHandler
    implements SubCommandHandler {
        @Override
        public void handle(@NotNull HandlerContext context, @NotNull String label, @Nullable Command command) throws ArgumentException {
            CommandContext commandContext = context.getContext();
            ArgumentStack stack = context.getStack();
            if (command == null) {
                throw new InvalidSubCommandException(TranslatableComponent.of("command.subcommand.invalid", TextComponent.of(label))).setArgument(context.getPart()).setCommand(commandContext.getCommand());
            }
            CommandManager manager = commandContext.getObject(CommandManager.class, "commandManager");
            if (!manager.getAuthorizer().isAuthorized(commandContext, command.getPermission())) {
                throw new NoPermissionsException(command.getPermissionMessage()).setCommand(command);
            }
            FallbackCommandModifiers fallbackModifiers = manager.getCommandModifiers();
            commandContext.setCommand(command, label);
            CommandModifiers modifiers = command.getModifiers();
            if (!modifiers.hasModifiers(ModifierPhase.PRE_PARSE) ? !fallbackModifiers.callModifiers(ModifierPhase.PRE_PARSE, commandContext, stack) : !modifiers.callModifiers(ModifierPhase.PRE_PARSE, commandContext, stack)) {
                throw new StopParseException();
            }
            command.getPart().parse(commandContext, stack, command.getPart());
        }
    }

    public static interface SubCommandHandler {
        public void handle(@NotNull HandlerContext var1, @NotNull String var2, @Nullable Command var3) throws ArgumentException;
    }

    private static class DefaultHandlerContext
    implements HandlerContext {
        private final SubCommandPart part;
        private final CommandContext context;
        private final ArgumentStack stack;

        public DefaultHandlerContext(SubCommandPart part, CommandContext context, ArgumentStack stack) {
            this.part = part;
            this.context = context;
            this.stack = stack;
        }

        @Override
        @NotNull
        public SubCommandPart getPart() {
            return this.part;
        }

        @Override
        @NotNull
        public CommandContext getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public ArgumentStack getStack() {
            return this.stack;
        }
    }

    public static interface HandlerContext {
        @NotNull
        public SubCommandPart getPart();

        @NotNull
        public CommandContext getContext();

        @NotNull
        public ArgumentStack getStack();
    }
}

