/*
 * Decompiled with CFR 0.152.
 */
package me.fixeddev.commandflow.stack;

import java.util.List;
import me.fixeddev.commandflow.exception.ArgumentParseException;
import me.fixeddev.commandflow.exception.NoMoreArgumentsException;
import me.fixeddev.commandflow.stack.StackSnapshot;

public interface ArgumentStack {
    public boolean hasNext();

    public String next() throws NoMoreArgumentsException;

    public String peek() throws NoMoreArgumentsException;

    public String current();

    public String remove();

    public int getPosition();

    public int getSize();

    public int getArgumentsLeft();

    public String nextQuoted();

    public int nextInt() throws ArgumentParseException;

    public float nextFloat() throws ArgumentParseException;

    public double nextDouble() throws ArgumentParseException;

    public byte nextByte() throws ArgumentParseException;

    public boolean nextBoolean() throws ArgumentParseException;

    public long nextLong() throws ArgumentParseException;

    public void markAsConsumed();

    public List<String> getBacking();

    public ArgumentStack getSlice(int var1, int var2);

    default public ArgumentStack getSliceFrom(int start) {
        return this.getSlice(start, this.getSize());
    }

    default public ArgumentStack getSliceTo(int end) {
        return this.getSlice(this.getPosition(), end);
    }

    default public ArgumentStack getSlice(int size) {
        return this.getSliceTo(this.getPosition() + size);
    }

    default public StackSnapshot getSnapshot() {
        return this.getSnapshot(true);
    }

    public StackSnapshot getSnapshot(boolean var1);

    default public void applySnapshot(StackSnapshot snapshot) {
        this.applySnapshot(snapshot, true);
    }

    public void applySnapshot(StackSnapshot var1, boolean var2);
}

