/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.serializer.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.kyori.text.Component;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.Style;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;
import net.kyori.text.serializer.gson.TextColorWrapper;

public class StyleSerializer
implements JsonDeserializer<Style>,
JsonSerializer<Style> {
    public static final StyleSerializer INSTANCE = new StyleSerializer();
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    static final String COLOR = "color";
    static final String INSERTION = "insertion";
    static final String CLICK_EVENT = "clickEvent";
    static final String CLICK_EVENT_ACTION = "action";
    static final String CLICK_EVENT_VALUE = "value";
    static final String HOVER_EVENT = "hoverEvent";
    static final String HOVER_EVENT_ACTION = "action";
    static final String HOVER_EVENT_VALUE = "value";

    public Style deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        return this.deserialize(object, typeOfT, context);
    }

    private Style deserialize(JsonObject json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject;
        String value;
        JsonPrimitive rawValue;
        JsonObject jsonObject2;
        Style.Builder style = Style.builder();
        if (json.has(COLOR)) {
            TextColorWrapper textColorWrapper = (TextColorWrapper)context.deserialize(json.get(COLOR), TextColorWrapper.class);
            if (textColorWrapper.color != null) {
                style.color(textColorWrapper.color);
            } else if (textColorWrapper.decoration != null) {
                style.decoration(textColorWrapper.decoration, true);
            }
        }
        for (TextDecoration decoration : DECORATIONS) {
            String name = TextDecoration.NAMES.name(decoration);
            if (!json.has(name)) continue;
            style.decoration(decoration, json.get(name).getAsBoolean());
        }
        if (json.has(INSERTION)) {
            style.insertion(json.get(INSERTION).getAsString());
        }
        if (json.has(CLICK_EVENT) && (jsonObject2 = json.getAsJsonObject(CLICK_EVENT)) != null) {
            ClickEvent.Action action;
            JsonPrimitive rawAction = jsonObject2.getAsJsonPrimitive("action");
            ClickEvent.Action action2 = action = rawAction == null ? null : (ClickEvent.Action)((Object)context.deserialize((JsonElement)rawAction, ClickEvent.Action.class));
            if (action != null && action.readable()) {
                rawValue = jsonObject2.getAsJsonPrimitive("value");
                String string = value = rawValue == null ? null : rawValue.getAsString();
                if (value != null) {
                    style.clickEvent(ClickEvent.of(action, value));
                }
            }
        }
        if (json.has(HOVER_EVENT) && (jsonObject = json.getAsJsonObject(HOVER_EVENT)) != null) {
            HoverEvent.Action action;
            JsonPrimitive rawAction = jsonObject.getAsJsonPrimitive("action");
            HoverEvent.Action action3 = action = rawAction == null ? null : (HoverEvent.Action)((Object)context.deserialize((JsonElement)rawAction, HoverEvent.Action.class));
            if (action != null && action.readable()) {
                rawValue = jsonObject.get("value");
                String string = value = rawValue == null ? null : (Component)context.deserialize((JsonElement)rawValue, Component.class);
                if (value != null) {
                    style.hoverEvent(HoverEvent.of(action, (Component)((Object)value)));
                }
            }
        }
        return style.build();
    }

    public JsonElement serialize(Style src, Type typeOfSrc, JsonSerializationContext context) {
        HoverEvent hoverEvent;
        ClickEvent clickEvent;
        String insertion;
        JsonObject json = new JsonObject();
        for (TextDecoration decoration : DECORATIONS) {
            TextDecoration.State state = src.decoration(decoration);
            if (state == TextDecoration.State.NOT_SET) continue;
            String name = TextDecoration.NAMES.name(decoration);
            json.addProperty(name, Boolean.valueOf(state == TextDecoration.State.TRUE));
        }
        TextColor color = src.color();
        if (color != null) {
            json.add(COLOR, context.serialize((Object)color));
        }
        if ((insertion = src.insertion()) != null) {
            json.add(INSERTION, context.serialize((Object)insertion));
        }
        if ((clickEvent = src.clickEvent()) != null) {
            JsonObject eventJson = new JsonObject();
            eventJson.add("action", context.serialize((Object)clickEvent.action()));
            eventJson.addProperty("value", clickEvent.value());
            json.add(CLICK_EVENT, (JsonElement)eventJson);
        }
        if ((hoverEvent = src.hoverEvent()) != null) {
            JsonObject eventJson = new JsonObject();
            eventJson.add("action", context.serialize((Object)hoverEvent.action()));
            eventJson.add("value", context.serialize((Object)hoverEvent.value()));
            json.add(HOVER_EVENT, (JsonElement)eventJson);
        }
        return json;
    }
}

