/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.assisted.provision;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import team.unnamed.inject.assisted.Assisted;
import team.unnamed.inject.assisted.ValueFactory;
import team.unnamed.inject.assisted.provision.ProxiedFactoryProvider;
import team.unnamed.inject.error.FactoryException;
import team.unnamed.inject.impl.BinderImpl;
import team.unnamed.inject.key.InjectedKey;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.provision.StdProvider;
import team.unnamed.inject.resolve.ComponentResolver;
import team.unnamed.inject.resolve.solution.InjectableConstructor;
import team.unnamed.inject.util.Validate;

public class ToFactoryProvider<T>
extends StdProvider<T> {
    private final TypeReference<? extends ValueFactory> factory;

    public ToFactoryProvider(TypeReference<? extends ValueFactory> factory) {
        this.factory = Validate.notNull(factory, "factory", new Object[0]);
    }

    @Override
    public boolean onBind(BinderImpl binder, Key<?> key) {
        Class<? extends ValueFactory> factoryRawType = this.factory.getRawType();
        TypeReference<?> required = key.getType();
        InjectableConstructor constructor = ComponentResolver.constructor().resolve(binder, required, Assisted.class);
        if (constructor == null) {
            binder.attach("Bad assisted object", new FactoryException("Cannot resolve constructor annotated with @Assisted in type " + required));
            return false;
        }
        if (!factoryRawType.isInterface()) {
            binder.attach("Factory " + this.factory + " must be an interface with one single method!");
            return false;
        }
        int methodCount = factoryRawType.getMethods().length;
        if (methodCount != 1) {
            binder.attach("Bad factory method", new FactoryException("Factory " + this.factory + " has invalid method count (expected: 1, found: " + methodCount + ")"));
            return false;
        }
        Method method = factoryRawType.getMethods()[0];
        TypeReference<?> methodReturnType = this.factory.resolve(method.getGenericReturnType());
        if (!required.equals(methodReturnType)) {
            binder.attach("Bad factory method", new FactoryException("Method " + method.getName() + " of factory " + this.factory + " must return " + required));
            return false;
        }
        List<InjectedKey<?>> keys = ComponentResolver.keys().keysOf(this.factory, method.getParameters());
        HashSet assists = new HashSet();
        for (InjectedKey<?> parameterKey : keys) {
            if (assists.add(parameterKey.getKey())) continue;
            binder.attach("Duplicated factory assisted keys", new FactoryException("Creator method has two equal assisted values! Consider using qualifiers to difference them (key " + parameterKey.getKey() + ")"));
            return false;
        }
        HashSet constructorAssists = new HashSet();
        for (InjectedKey injectedKey : constructor.getKeys()) {
            if (!injectedKey.isAssisted()) continue;
            if (!assists.contains(injectedKey.getKey())) {
                binder.attach("Unsatisfied Assisted Constructor", new FactoryException("Constructor requires assist for " + injectedKey.getKey() + " and method doesn't give it!"));
                return false;
            }
            if (constructorAssists.add(injectedKey.getKey())) continue;
            binder.attach("Duplicated constructor assisted keys", new FactoryException("Constructor has two equal assisted keys! Consider using qualifiers to difference them (key " + injectedKey.getKey() + ")"));
            return false;
        }
        if (assists.size() != constructorAssists.size()) {
            binder.attach("Assists mismatch, different assisted injections count", new FactoryException("Assists mismatch! Constructor has " + constructorAssists.size() + " values and method " + assists.size() + " values."));
            return false;
        }
        Key<?> castedKey = key;
        binder.$unsafeBind(Key.of(this.factory), new ProxiedFactoryProvider(factoryRawType, method, keys, constructor, castedKey));
        return false;
    }

    @Override
    public T get() {
        throw new IllegalStateException("The instance is bound to a Factory, you must get an instance of that factory!");
    }
}

