/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.impl;

import java.lang.reflect.Modifier;
import team.unnamed.inject.ProvidedBy;
import team.unnamed.inject.Targetted;
import team.unnamed.inject.impl.BinderImpl;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.provision.Providers;
import team.unnamed.inject.provision.StdProvider;
import team.unnamed.inject.scope.Scope;
import team.unnamed.inject.scope.Scopes;

final class AnnotationScanner {
    private AnnotationScanner() {
    }

    static <T> void bind(TypeReference<T> keyType, BinderImpl binder) {
        Key<T> key = Key.of(keyType);
        StdProvider<T> provider = binder.getProvider(key);
        if (provider != null) {
            return;
        }
        Class<T> rawType = keyType.getRawType();
        Targetted target = rawType.getAnnotation(Targetted.class);
        ProvidedBy providedBy = rawType.getAnnotation(ProvidedBy.class);
        if (target != null) {
            Key linkedKey = Key.of(TypeReference.of(target.value()));
            binder.$unsafeBind(key, Providers.link(key, linkedKey));
        } else if (providedBy != null) {
            TypeReference linkedProvider = TypeReference.of(providedBy.value());
            binder.$unsafeBind(key, Providers.providerTypeProvider(linkedProvider));
        }
    }

    static <T> void scope(TypeReference<T> keyType, BinderImpl binder) {
        Key<T> key = Key.of(keyType);
        StdProvider<T> provider = binder.getProvider(key);
        Class<T> rawType = keyType.getRawType();
        if (provider == null && !rawType.isInterface() && !Modifier.isAbstract(rawType.getModifiers())) {
            provider = Providers.normalize(Providers.link(key, key));
        }
        if (provider == null) {
            return;
        }
        Scope scope = Scopes.getScanner().scan(rawType);
        if (scope != Scopes.NONE) {
            binder.$unsafeBind(key, provider.withScope(key, scope));
        }
    }
}

