/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.inject.Named;
import team.unnamed.inject.util.Validate;

public final class Annotations {
    private Annotations() {
    }

    public static boolean containsOnlyDefaultValues(Annotation annotation) {
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            Object defaultValue = method.getDefaultValue();
            if (defaultValue == null) {
                return false;
            }
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                if (defaultValue.equals(value)) continue;
                return false;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return true;
    }

    public static Named createNamed(String name) {
        Validate.notNull(name);
        return new NamedImpl(name);
    }

    private static class NamedImpl
    implements Named {
        private final String name;
        private final int hashCode;

        private NamedImpl(String name) {
            this.name = name;
            this.hashCode = 127 * "value".hashCode() ^ name.hashCode();
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Named.class;
        }

        @Override
        public String value() {
            return this.name;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Named)) {
                return false;
            }
            return this.name.equals(((Named)obj).value());
        }

        @Override
        public String toString() {
            return "@Named(\"" + this.name + "\")";
        }
    }
}

