/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.impl;

import javax.inject.Provider;
import team.unnamed.inject.Binder;
import team.unnamed.inject.impl.BinderImpl;
import team.unnamed.inject.impl.KeyBuilder;
import team.unnamed.inject.impl.LinkedBuilder;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.provision.Providers;
import team.unnamed.inject.scope.Scope;
import team.unnamed.inject.util.Validate;

class BindingBuilderImpl<T>
implements Binder.QualifiedBindingBuilder<T>,
KeyBuilder<Binder.QualifiedBindingBuilder<T>, T>,
LinkedBuilder<Binder.Scoped, T> {
    private final BinderImpl binder;
    private Key<T> key;

    protected BindingBuilderImpl(BinderImpl binder, TypeReference<T> key) {
        this.key = Key.of(key);
        this.binder = binder;
    }

    @Override
    public void in(Scope scope) {
        Validate.notNull(scope, "scope", new Object[0]);
        this.selfBindingIfNotBound();
        this.binder.$unsafeBind(this.key, this.binder.getProvider(this.key).withScope(this.key, scope));
    }

    @Override
    public Binder.Scoped toProvider(Provider<? extends T> provider) {
        Validate.notNull(provider, "provider", new Object[0]);
        this.requireNotBound();
        this.binder.$unsafeBind(this.key, provider);
        return this;
    }

    @Override
    public void toInstance(T instance) {
        Validate.notNull(instance, "instance", new Object[0]);
        this.toProvider(Providers.instanceProvider(this.key, instance));
    }

    private void requireNotBound() {
        if (this.binder.getProvider(this.key) != null) {
            throw new IllegalStateException("The key is already bound");
        }
    }

    private void selfBindingIfNotBound() {
        if (this.binder.getProvider(this.key) == null) {
            this.toProvider(Providers.link(this.key, this.key));
        }
    }

    @Override
    public Key<T> key() {
        return this.key;
    }

    @Override
    public void setKey(Key<T> key) {
        this.key = key;
    }

    @Override
    public Binder.QualifiedBindingBuilder<T> getReturnValue() {
        return this;
    }
}

