/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import team.unnamed.inject.error.ErrorAttachableImpl;
import team.unnamed.inject.key.Key;

public class ProvisionStack
extends ErrorAttachableImpl {
    private final Map<Key<?>, Object> values = new HashMap();
    private final LinkedList<KeyInstanceEntry<?>> stack = new LinkedList();

    public boolean has(Key<?> key) {
        return this.values.containsKey(key);
    }

    public <T> T get(Key<T> key) {
        Object value = this.values.get(key);
        return (T)value;
    }

    public void pop() {
        Map.Entry entry = this.stack.removeFirst();
        if (entry != null) {
            this.values.remove(entry.getKey());
        }
    }

    public <T> void push(Key<T> key, T value) {
        this.values.put(key, value);
        this.stack.addFirst(new KeyInstanceEntry<T>(key, value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append(this.errorCount());
        builder.append(" errors");
        builder.append(") ");
        Iterator entries = this.stack.iterator();
        while (entries.hasNext()) {
            KeyInstanceEntry entry = (KeyInstanceEntry)entries.next();
            builder.append(entry.getKey());
            if (!entries.hasNext()) continue;
            builder.append(" -> ");
        }
        return builder.toString();
    }

    private static class KeyInstanceEntry<T>
    implements Map.Entry<Key<?>, Object> {
        private final Key<T> key;
        private final T value;

        public KeyInstanceEntry(Key<T> key, T value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Key<?> getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public T setValue(Object value) {
            throw new UnsupportedOperationException("This entry is immutable!");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyInstanceEntry that = (KeyInstanceEntry)o;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }

        @Override
        public int hashCode() {
            int result = 1;
            result = 31 * result + this.key.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }
}

