/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.key;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.key.Types;
import team.unnamed.inject.util.Validate;

final class CompositeTypeReflector {
    private CompositeTypeReflector() {
    }

    private static Type getSupertype(Type type, Class<?> rawType, Class<?> resolvingType) {
        Validate.notNull(type, "type", new Object[0]);
        Validate.notNull(rawType, "rawType", new Object[0]);
        Validate.notNull(resolvingType, "resolvingType", new Object[0]);
        if (resolvingType == rawType) {
            return type;
        }
        if (resolvingType.isInterface()) {
            Class<?>[] rawInterfaceTypes = rawType.getInterfaces();
            Type[] genericInterfaceTypes = rawType.getGenericInterfaces();
            for (int i = 0; i < rawInterfaceTypes.length; ++i) {
                Class<?> rawInterfaceType = rawInterfaceTypes[i];
                Type interfaceType = genericInterfaceTypes[i];
                if (rawInterfaceType == resolvingType) {
                    return interfaceType;
                }
                if (!resolvingType.isAssignableFrom(rawInterfaceType)) continue;
                return CompositeTypeReflector.getSupertype(interfaceType, rawInterfaceType, resolvingType);
            }
        }
        if (rawType.isInterface() || rawType == Object.class) {
            return resolvingType;
        }
        Class<?> rawSupertype = rawType.getSuperclass();
        while (rawType != null && rawType != Object.class) {
            if (rawSupertype == resolvingType) {
                return rawType.getGenericSuperclass();
            }
            if (resolvingType.isAssignableFrom(rawSupertype)) {
                return CompositeTypeReflector.getSupertype(rawType.getGenericSuperclass(), rawSupertype, resolvingType);
            }
            rawSupertype = rawType.getSuperclass();
            rawType = rawSupertype;
        }
        return resolvingType;
    }

    private static Type resolveTypeVariable(TypeReference<?> context, TypeVariable<?> typeVariable) {
        Object declaration = typeVariable.getGenericDeclaration();
        if (!(declaration instanceof Class)) {
            return typeVariable;
        }
        Class classDeclaration = (Class)declaration;
        TypeVariable<Class<T>>[] parameters = classDeclaration.getTypeParameters();
        Type contextSupertype = CompositeTypeReflector.getSupertype(context.getType(), context.getRawType(), classDeclaration);
        if (!(contextSupertype instanceof ParameterizedType)) {
            return typeVariable;
        }
        for (int i = 0; i < parameters.length; ++i) {
            TypeVariable parameter = parameters[i];
            if (!parameter.equals(typeVariable)) continue;
            return CompositeTypeReflector.resolveContextually(context, ((ParameterizedType)contextSupertype).getActualTypeArguments()[i]);
        }
        throw new IllegalStateException("Cannot resolve type variable, no type argument found");
    }

    private static Type resolveWildcardType(TypeReference<?> context, WildcardType wildcardType) {
        Type resolvedUpperBound;
        Type upperBound;
        Type resolvedLowerBound;
        Type lowerBound;
        Type[] lowerBounds = wildcardType.getLowerBounds();
        Type[] upperBounds = wildcardType.getUpperBounds();
        if (lowerBounds.length == 1 && (lowerBound = lowerBounds[0]) != (resolvedLowerBound = CompositeTypeReflector.resolveContextually(context, lowerBound))) {
            return Types.wildcardSuperTypeOf(resolvedLowerBound);
        }
        if (upperBounds.length == 1 && (upperBound = upperBounds[0]) != (resolvedUpperBound = CompositeTypeReflector.resolveContextually(context, upperBound))) {
            return Types.wildcardSubTypeOf(resolvedUpperBound);
        }
        return wildcardType;
    }

    private static Type resolveParameterizedType(TypeReference<?> context, ParameterizedType type) {
        Type ownerType = type.getOwnerType();
        Type resolvedOwnerType = CompositeTypeReflector.resolveContextually(context, ownerType);
        Type[] typeParameters = type.getActualTypeArguments();
        boolean changed = resolvedOwnerType != ownerType;
        if (changed) {
            typeParameters = (Type[])typeParameters.clone();
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            Type typeParameter = typeParameters[i];
            Type resolvedTypeParameter = CompositeTypeReflector.resolveContextually(context, typeParameter);
            if (typeParameter == resolvedTypeParameter) continue;
            if (!changed) {
                typeParameters = (Type[])typeParameters.clone();
                changed = true;
            }
            typeParameters[i] = resolvedTypeParameter;
        }
        if (changed) {
            Type rawType = type.getRawType();
            return Types.parameterizedTypeOf(resolvedOwnerType, (Class)rawType, typeParameters);
        }
        return type;
    }

    private static Type resolveGenericArrayType(TypeReference<?> context, GenericArrayType genericArrayType) {
        Type resolvedComponentType;
        Type componentType = genericArrayType.getGenericComponentType();
        if (componentType == (resolvedComponentType = CompositeTypeReflector.resolveContextually(context, componentType))) {
            return genericArrayType;
        }
        return Types.genericArrayTypeOf(resolvedComponentType);
    }

    static Type resolveContextually(TypeReference<?> context, Type type) {
        if (type instanceof TypeVariable) {
            return CompositeTypeReflector.resolveTypeVariable(context, (TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return CompositeTypeReflector.resolveWildcardType(context, (WildcardType)type);
        }
        if (type instanceof ParameterizedType) {
            return CompositeTypeReflector.resolveParameterizedType(context, (ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return CompositeTypeReflector.resolveGenericArrayType(context, (GenericArrayType)type);
        }
        return type;
    }
}

