/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.multibinding;

import java.util.Collections;
import java.util.Map;
import javax.inject.Provider;
import team.unnamed.inject.impl.InjectorImpl;
import team.unnamed.inject.impl.ProvisionStack;
import team.unnamed.inject.multibinding.MapCreator;
import team.unnamed.inject.provision.Providers;
import team.unnamed.inject.provision.StdProvider;

class MapBoundProvider<K, V>
extends StdProvider<Map<K, V>> {
    private final Map<K, Provider<? extends V>> delegates;
    private final MapCreator mapCreator;

    MapBoundProvider(MapCreator mapCreator) {
        this.delegates = mapCreator.create();
        this.mapCreator = mapCreator;
    }

    @Override
    public void inject(ProvisionStack stack, InjectorImpl injector) {
        this.delegates.forEach((key, valueProvider) -> Providers.inject(stack, injector, valueProvider));
        this.injected = true;
    }

    @Override
    public Map<K, V> get() {
        Map map = this.mapCreator.create();
        this.delegates.forEach((key, valueProvider) -> map.put(key, valueProvider.get()));
        return map;
    }

    public Map<K, Provider<? extends V>> getProviders() {
        return Collections.unmodifiableMap(this.delegates);
    }

    Map<K, Provider<? extends V>> getModifiableProviderMap() {
        return this.delegates;
    }

    public String toString() {
        return "MapMultiBound(" + this.delegates + ")";
    }
}

