/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.multibinding;

import team.unnamed.inject.Binder;
import team.unnamed.inject.impl.BinderImpl;
import team.unnamed.inject.impl.KeyBuilder;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.multibinding.CollectionCreator;
import team.unnamed.inject.multibinding.CollectionMultiBindingBuilderImpl;
import team.unnamed.inject.multibinding.MapCreator;
import team.unnamed.inject.multibinding.MapMultiBindingBuilderImpl;

public class MultiBindingBuilderImpl<T>
implements Binder.MultiBindingBuilder<T>,
KeyBuilder<Binder.MultiBindingBuilder<T>, T> {
    private final BinderImpl binder;
    private Key<T> key;

    public MultiBindingBuilderImpl(BinderImpl binder, TypeReference<T> key) {
        this.key = Key.of(key);
        this.binder = binder;
    }

    @Override
    public Binder.CollectionMultiBindingBuilder<T> asCollection(Class<?> baseType, CollectionCreator collectionCreator) {
        Key listKey = this.key.withType(TypeReference.of(baseType, this.key.getType().getType()));
        return new CollectionMultiBindingBuilderImpl<T>(this.binder, listKey, this.key, collectionCreator);
    }

    @Override
    public <K> Binder.MapMultiBindingBuilder<K, T> asMap(TypeReference<K> keyReference, MapCreator mapCreator) {
        Key mapKey = this.key.withType(TypeReference.mapTypeOf(keyReference, this.key.getType()));
        return new MapMultiBindingBuilderImpl(this.binder, mapCreator, mapKey, this.key);
    }

    @Override
    public Key<T> key() {
        return this.key;
    }

    @Override
    public void setKey(Key<T> key) {
        this.key = key;
    }

    @Override
    public Binder.MultiBindingBuilder<T> getReturnValue() {
        return this;
    }
}

