/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.provision;

import javax.inject.Provider;
import team.unnamed.inject.impl.InjectorImpl;
import team.unnamed.inject.impl.ProvisionStack;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.provision.DelegatingStdProvider;
import team.unnamed.inject.provision.StdProvider;
import team.unnamed.inject.provision.std.InstanceProvider;
import team.unnamed.inject.provision.std.LinkedProvider;
import team.unnamed.inject.provision.std.ProviderTypeProvider;
import team.unnamed.inject.provision.std.ScopedProvider;
import team.unnamed.inject.util.Validate;

public final class Providers {
    private Providers() {
    }

    public static void inject(ProvisionStack stack, InjectorImpl injector, Provider<?> provider) {
        if (provider instanceof StdProvider) {
            ((StdProvider)provider).inject(stack, injector);
        } else {
            injector.injectMembers(stack, Key.of(TypeReference.of(provider.getClass())), provider);
        }
    }

    public static <T> Provider<T> unwrap(Provider<T> provider) {
        if (provider instanceof DelegatingStdProvider) {
            return Providers.unwrap(((DelegatingStdProvider)provider).getDelegate());
        }
        if (provider instanceof ScopedProvider) {
            return Providers.unwrap(((ScopedProvider)provider).getUnscoped());
        }
        return provider;
    }

    public static <T> StdProvider<T> normalize(Provider<T> provider) {
        if (provider instanceof StdProvider) {
            return (StdProvider)provider;
        }
        return new DelegatingStdProvider<T>(provider);
    }

    public static <T> Provider<? extends T> instanceProvider(Key<T> key, T instance) {
        Validate.notNull(key, "key", new Object[0]);
        Validate.notNull(instance, "instance", new Object[0]);
        return new InstanceProvider<T>(instance);
    }

    public static <T> Provider<? extends T> providerTypeProvider(TypeReference<? extends Provider<? extends T>> providerClass) {
        Validate.notNull(providerClass);
        return new ProviderTypeProvider(providerClass);
    }

    public static <T> Provider<? extends T> link(Key<T> key, Key<? extends T> target) {
        Validate.notNull(key, "key", new Object[0]);
        Validate.notNull(target, "target", new Object[0]);
        return new LinkedProvider<T>(key, target);
    }
}

