/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.provision.std;

import javax.inject.Provider;
import team.unnamed.inject.impl.InjectorImpl;
import team.unnamed.inject.impl.ProvisionStack;
import team.unnamed.inject.key.Key;
import team.unnamed.inject.provision.Providers;
import team.unnamed.inject.provision.StdProvider;
import team.unnamed.inject.scope.Scope;
import team.unnamed.inject.util.Validate;

public class ScopedProvider<T>
extends StdProvider<T>
implements Provider<T> {
    private final Provider<T> unscoped;
    private final Provider<T> scoped;
    private final Scope scope;

    public ScopedProvider(Provider<T> provider, Scope scope) {
        this.unscoped = Validate.notNull(provider, "provider", new Object[0]);
        this.scope = Validate.notNull(scope, "scope", new Object[0]);
        this.scoped = scope.scope(provider);
    }

    protected ScopedProvider() {
        this.unscoped = null;
        this.scoped = null;
        this.scope = null;
    }

    @Override
    public Provider<T> withScope(Key<?> match, Scope scope) {
        if (this.scope == scope) {
            return this;
        }
        throw new UnsupportedOperationException("Cannot scope the provider again! Scope: " + scope.getClass().getSimpleName() + ". Provider: " + this.unscoped);
    }

    @Override
    public void inject(ProvisionStack stack, InjectorImpl injector) {
        Providers.inject(stack, injector, this.unscoped);
        Providers.inject(stack, injector, this.scoped);
        this.injected = true;
    }

    @Override
    public T get() {
        return this.scoped.get();
    }

    public Provider<T> getUnscoped() {
        return this.unscoped;
    }

    public Provider<T> getScoped() {
        return this.scoped;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean requiresJitScoping() {
        return false;
    }
}

