/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import javax.inject.Inject;
import team.unnamed.inject.error.ErrorAttachable;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.resolve.ComponentResolver;
import team.unnamed.inject.resolve.Solution;
import team.unnamed.inject.resolve.solution.InjectableConstructor;

public final class ConstructorResolver {
    static final Object CONSTRUCTOR_NOT_DEFINED = new Object();

    ConstructorResolver() {
    }

    public InjectableConstructor get(ErrorAttachable errors, TypeReference<?> type) {
        Solution solution = ComponentResolver.SOLUTIONS.get(type);
        if (solution == null || solution.constructor == CONSTRUCTOR_NOT_DEFINED) {
            if (solution == null) {
                solution = new Solution();
                ComponentResolver.SOLUTIONS.put(type, solution);
            }
            solution.constructor = this.resolve(errors, type, Inject.class);
        }
        return (InjectableConstructor)solution.constructor;
    }

    public InjectableConstructor resolve(ErrorAttachable errors, TypeReference<?> type, Class<? extends Annotation> annotation) {
        Class<?> rawType = type.getRawType();
        Constructor<?> injectableConstructor = null;
        for (Constructor<?> constructor : rawType.getDeclaredConstructors()) {
            if (!constructor.isAnnotationPresent(annotation)) continue;
            injectableConstructor = constructor;
            break;
        }
        if (injectableConstructor == null) {
            try {
                injectableConstructor = rawType.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (injectableConstructor == null) {
            errors.attach("No constructor found for type '" + type + "'");
            return null;
        }
        return new InjectableConstructor(ComponentResolver.keys().keysOf(type, injectableConstructor.getParameters()), injectableConstructor);
    }
}

