/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.resolve.ComponentResolver;
import team.unnamed.inject.resolve.Solution;
import team.unnamed.inject.resolve.solution.InjectableMethod;

public final class MethodResolver {
    MethodResolver() {
    }

    public List<InjectableMethod> get(TypeReference<?> type) {
        Solution solution = ComponentResolver.SOLUTIONS.get(type);
        if (solution == null || solution.methods == null) {
            if (solution == null) {
                solution = new Solution();
                ComponentResolver.SOLUTIONS.put(type, solution);
            }
            if (solution.methods == null) {
                solution.methods = this.resolve(type, Inject.class);
            }
        }
        return solution.methods;
    }

    public List<InjectableMethod> resolve(TypeReference<?> type, Class<? extends Annotation> annotation) {
        Class<?> clazz;
        ArrayList<InjectableMethod> methods = new ArrayList<InjectableMethod>();
        for (Class<?> checking = clazz = type.getRawType(); checking != null && checking != Object.class; checking = checking.getSuperclass()) {
            for (Method method : checking.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotation)) continue;
                methods.add(new InjectableMethod(type, ComponentResolver.KEY_RESOLVER.keysOf(type, method.getParameters()), method));
            }
        }
        return methods;
    }
}

