/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.resolve.solution;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import team.unnamed.inject.impl.InjectorImpl;
import team.unnamed.inject.impl.ProvisionStack;
import team.unnamed.inject.key.InjectedKey;
import team.unnamed.inject.key.TypeReference;
import team.unnamed.inject.resolve.solution.InjectableMember;
import team.unnamed.inject.util.ElementFormatter;
import team.unnamed.inject.util.Validate;

public class InjectableMethod
implements InjectableMember {
    private final TypeReference<?> declaringType;
    private final List<InjectedKey<?>> keys;
    private final Method method;

    public InjectableMethod(TypeReference<?> declaringType, List<InjectedKey<?>> keys, Method method) {
        this.declaringType = Validate.notNull(declaringType);
        this.keys = Collections.unmodifiableList(keys);
        this.method = Validate.notNull(method);
        for (InjectedKey<?> key : keys) {
            Validate.doesntRequiresContext(key.getKey());
        }
        this.method.setAccessible(true);
    }

    @Override
    public TypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public Method getMember() {
        return this.method;
    }

    @Override
    public Object inject(InjectorImpl injector, ProvisionStack stack, Object target) {
        if (target == null ^ Modifier.isStatic(this.method.getModifiers())) {
            return null;
        }
        Object[] values = new Object[this.keys.size()];
        for (int i = 0; i < this.keys.size(); ++i) {
            InjectedKey<?> key = this.keys.get(i);
            Object value = injector.getValue(key, stack);
            if (value == InjectorImpl.ABSENT_INSTANCE) {
                stack.attach("Cannot inject '" + this.method.getName() + "' method.\n\tAt:" + this.declaringType + "\n\tReason: Cannot get value for required parameter (index " + i + ") \n\tRequired Key: " + key.getKey());
                return null;
            }
            values[i] = value;
        }
        try {
            return this.method.invoke(target, values);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            stack.attach("Cannot inject method " + ElementFormatter.formatMethod(this.method, this.keys), e);
            return null;
        }
    }
}

