/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.inject.scope;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import team.unnamed.inject.scope.Scope;
import team.unnamed.inject.scope.Scopes;
import team.unnamed.inject.util.Validate;

public final class ScopeScanner {
    private final Map<Class<? extends Annotation>, Scope> scopes = new HashMap<Class<? extends Annotation>, Scope>();

    ScopeScanner() {
        this.scopes.put(Singleton.class, Scopes.SINGLETON);
    }

    public void bind(Class<? extends Annotation> annotationType, Scope scope) {
        Validate.notNull(annotationType, "annotationType", new Object[0]);
        Validate.notNull(scope, "scope", new Object[0]);
        this.scopes.put(annotationType, scope);
    }

    public Scope scan(AnnotatedElement element) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = element.getDeclaredAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Scope scope = this.scopes.get(annotationType);
            if (scope == null) continue;
            return scope;
        }
        return Scopes.NONE;
    }
}

