/*
 * Decompiled with CFR 0.152.
 */
package kabopc.village_marker.client;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kabopc.village_marker.client.DoorView;
import kabopc.village_marker.client.KaboVillageMarkerRenderer;
import kabopc.village_marker.client.VillageView;
import net.ornithemc.osl.networking.api.client.ClientPlayNetworking;

public class KaboVillageMarkerClient {
    public static final KaboVillageMarkerClient INSTANCE = new KaboVillageMarkerClient();
    public final KaboVillageMarkerRenderer renderer = new KaboVillageMarkerRenderer(this);
    public final List<VillageView> villages = new ArrayList<VillageView>();

    private KaboVillageMarkerClient() {
    }

    public void reset(boolean query) {
        this.villages.clear();
        if (query) {
            ClientPlayNetworking.send((String)"KVM|Data", data -> {});
        }
    }

    public void update(DataInput data) throws IOException {
        this.villages.clear();
        int villageCount = data.readInt();
        for (int i = 0; i < villageCount; ++i) {
            byte radius = data.readByte();
            int centerX = data.readInt();
            int centerY = data.readInt();
            int centerZ = data.readInt();
            VillageView village = new VillageView(radius, centerX, centerY, centerZ);
            this.villages.add(village);
            int doorCount = data.readInt();
            for (int j = 0; j < doorCount; ++j) {
                int doorX = data.readInt();
                int doorY = data.readInt();
                int doorZ = data.readInt();
                DoorView door = new DoorView(doorX, doorY, doorZ);
                village.doors.add(door);
            }
        }
    }
}

