/*
 * Decompiled with CFR 0.152.
 */
package com.whirdle.customshortcuts.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.whirdle.customshortcuts.client.CustomshortcutsClient;
import com.whirdle.customshortcuts.client.properties.PropertiesManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

@Environment(value=EnvType.CLIENT)
public class Command {
    public static int registerAllShortcuts(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        int registeredCommands = 0;
        String[] stringArray = PropertiesManager.getAllShortcuts();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String shortcut;
            String currentShortcut = shortcut = stringArray[i];
            String command = PropertiesManager.getShortcutCommand(shortcut);
            if (PropertiesManager.getShortcutCommand(shortcut).contains("$v")) {
                Command.registerDynamicShortcut(shortcut, command, dispatcher);
                ++registeredCommands;
                continue;
            }
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)currentShortcut).executes(context1 -> {
                ((FabricClientCommandSource)context1.getSource()).getClient().method_1562().method_45730(PropertiesManager.getShortcutCommand(currentShortcut));
                return 1;
            }));
            ++registeredCommands;
            CustomshortcutsClient.LOGGER.info("registered shortcut " + shortcut + " which runs: /" + command);
        }
        CustomshortcutsClient.LOGGER.info("registered " + registeredCommands + " shortcuts");
        return registeredCommands;
    }

    public static void registerDynamicShortcut(String shortcut, String command, CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)shortcut).then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String allArgs = StringArgumentType.getString((CommandContext)context, (String)"args");
            String finalCommand = Command.processCommand(command, allArgs);
            ((FabricClientCommandSource)context.getSource()).getClient().method_1562().method_45730(finalCommand);
            return 1;
        })));
    }

    private static String processCommand(String command, String args) {
        String[] argValues = args.split(" ");
        int argIndex = 0;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < command.length(); ++i) {
            if (command.charAt(i) == '$' && i + 1 < command.length() && command.charAt(i + 1) == 'v') {
                if (argIndex < argValues.length) {
                    result.append(argValues[argIndex]);
                    ++argIndex;
                }
                ++i;
                continue;
            }
            result.append(command.charAt(i));
        }
        return result.toString();
    }
}

