/*
 * Decompiled with CFR 0.152.
 */
package com.whirdle.customshortcuts.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.whirdle.customshortcuts.client.properties.PropertiesManager;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class CustomshortcutsClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"customshortcuts");
    private static CommandDispatcher<FabricClientCommandSource> commandDispatcher;

    public void onInitializeClient() {
        LOGGER.info("started custom shortcuts plugin. you killed my father. prepare to die");
        PropertiesManager.reloadStorage();
        CustomshortcutsClient.registerAllShortcuts();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"shortcut").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"shortcut", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String shortcut = StringArgumentType.getString((CommandContext)context, (String)"shortcut");
            String command = StringArgumentType.getString((CommandContext)context, (String)"command");
            PropertiesManager.setShortcut(shortcut, command);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Shortcut created: " + shortcut)));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)shortcut).executes(ctx -> {
                ((FabricClientCommandSource)ctx.getSource()).getClient().method_1562().method_45730(command);
                return 1;
            }));
            PropertiesManager.saveStorage();
            return 1;
        }))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"shortcut", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String shortcut = StringArgumentType.getString((CommandContext)context, (String)"shortcut");
            PropertiesManager.removeShortcut(shortcut);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Shortcut removed: " + shortcut)));
            PropertiesManager.saveStorage();
            return 1;
        })))).then(ClientCommandManager.literal((String)"get").then(ClientCommandManager.argument((String)"shortcut", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String shortcut = StringArgumentType.getString((CommandContext)context, (String)"shortcut");
            String cmd = PropertiesManager.getShortcutCommand(shortcut);
            if (cmd != null) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(shortcut + " will execute: /" + cmd)));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Shortcut '" + shortcut + "' not found")));
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"reload").executes(context -> {
            PropertiesManager.reloadStorage();
            int registeredShortcuts = CustomshortcutsClient.registerAllShortcuts();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Registered " + registeredShortcuts + " shortcuts")));
            return 1;
        }))));
    }

    public static int registerAllShortcuts() {
        int registeredCommands = 0;
        String[] stringArray = PropertiesManager.getAllShortcuts();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String shortcut;
            String currentShortcut = shortcut = stringArray[i];
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)currentShortcut).executes(context1 -> {
                ((FabricClientCommandSource)context1.getSource()).getClient().method_1562().method_45730(PropertiesManager.getShortcutCommand(currentShortcut));
                return 1;
            })));
            ++registeredCommands;
            LOGGER.info("registered shortcut " + shortcut + " which runs: /" + PropertiesManager.getShortcutCommand(shortcut));
        }
        LOGGER.info("registered " + registeredCommands + " shortcuts");
        return registeredCommands;
    }
}

