/*
 * Decompiled with CFR 0.152.
 */
package com.whirdle.customshortcuts.client.properties;

import com.whirdle.customshortcuts.client.CustomshortcutsClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class PropertiesManager {
    private static final File storagePropertiesFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "customshortcuts/storage.txt");
    private static Properties properties = new Properties();

    public static void loadStorage() {
        if (!storagePropertiesFile.getParentFile().exists()) {
            storagePropertiesFile.getParentFile().mkdirs();
        }
        if (!storagePropertiesFile.exists()) {
            try {
                storagePropertiesFile.createNewFile();
                CustomshortcutsClient.LOGGER.info("Created new storage file at: " + storagePropertiesFile.getAbsolutePath());
            }
            catch (IOException e) {
                CustomshortcutsClient.LOGGER.error("Failed to create storage file", (Throwable)e);
                return;
            }
        }
        try (FileInputStream fis = new FileInputStream(storagePropertiesFile);){
            properties.load(fis);
            CustomshortcutsClient.LOGGER.info("Successfully loaded storage");
        }
        catch (IOException e) {
            CustomshortcutsClient.LOGGER.info("Failed to load storage:\n" + e.getMessage());
        }
    }

    public static void reloadStorage() {
        if (!storagePropertiesFile.getParentFile().exists()) {
            storagePropertiesFile.getParentFile().mkdirs();
        }
        if (!storagePropertiesFile.exists()) {
            try {
                storagePropertiesFile.createNewFile();
                CustomshortcutsClient.LOGGER.info("Created new storage file at: " + storagePropertiesFile.getAbsolutePath());
            }
            catch (IOException e) {
                CustomshortcutsClient.LOGGER.error("Failed to create storage file", (Throwable)e);
                return;
            }
        }
        try (FileInputStream fis = new FileInputStream(storagePropertiesFile);){
            properties.clear();
            properties.load(fis);
            CustomshortcutsClient.LOGGER.info("Successfully reloaded storage");
        }
        catch (IOException e) {
            CustomshortcutsClient.LOGGER.info("Failed to reload storage:\n" + e.getMessage());
        }
    }

    public static void saveStorage() {
        if (!storagePropertiesFile.getParentFile().exists()) {
            storagePropertiesFile.getParentFile().mkdirs();
        }
        if (!storagePropertiesFile.exists()) {
            try {
                storagePropertiesFile.createNewFile();
                CustomshortcutsClient.LOGGER.info("Created new storage file at: " + storagePropertiesFile.getAbsolutePath());
            }
            catch (IOException e) {
                CustomshortcutsClient.LOGGER.error("Failed to create storage file", (Throwable)e);
                return;
            }
        }
        try (FileOutputStream fos = new FileOutputStream(storagePropertiesFile);){
            properties.store(fos, "Custom Command Shortcuts Storage");
            CustomshortcutsClient.LOGGER.info("Storage saved successfully");
        }
        catch (IOException e) {
            CustomshortcutsClient.LOGGER.info("Failed to save storage file:\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void setShortcut(String shortcut, String command) {
        properties.setProperty(shortcut, command);
        CustomshortcutsClient.LOGGER.info("created command shortcut " + shortcut + " which runs: /" + command);
    }

    public static void removeShortcut(String shortcut) {
        properties.remove(shortcut);
    }

    public static String getShortcutCommand(String shortcut) {
        return properties.getProperty(shortcut);
    }

    public static String[] getAllShortcuts() {
        return properties.stringPropertyNames().toArray(new String[0]);
    }
}

