/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cz.yorick.NecromancersShadow;
import cz.yorick.data.NecromancyAttachments;
import cz.yorick.data.ShadowData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9473;

public class NecromancerData {
    public static final String SOUL_ENERGY_TRANSLATION_KEY = "tooltip.necromancers-shadow.soul_energy";
    private static final MapCodec<Pair<Double, Integer>> ENERGY_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("soulEnergy").forGetter(Pair::getFirst), (App)class_5699.field_33441.fieldOf("maxSoulEnergy").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::new));
    public static Codec<NecromancerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ShadowData.CODEC.listOf().fieldOf("shadows").forGetter(data -> data.storedShadows), (App)ENERGY_CODEC.forGetter(data -> Pair.of((Object)data.soulEnergy, (Object)data.maxSoulEnergy))).apply((Applicative)instance, NecromancerData::new));
    public static class_9139<class_9129, NecromancerData> PACKET_CODEC = class_9135.method_56896((Codec)RecordCodecBuilder.create(instance -> instance.group((App)ShadowData.SYNC_CODEC.listOf().fieldOf("shadows").forGetter(data -> data.storedShadows), (App)ENERGY_CODEC.forGetter(data -> Pair.of((Object)data.soulEnergy, (Object)data.maxSoulEnergy))).apply((Applicative)instance, NecromancerData::new)));
    private final List<ShadowData> storedShadows;
    private double soulEnergy;
    private int maxSoulEnergy;
    private final ConcurrentHashMap<ShadowData, class_1308> spawnedShadows;
    private boolean spawned = false;

    private NecromancerData(List<ShadowData> storedShadows, Pair<Double, Integer> soulEnergy) {
        this(new ArrayList<ShadowData>(storedShadows), (Double)soulEnergy.getFirst(), (Integer)soulEnergy.getSecond(), new ConcurrentHashMap<ShadowData, class_1308>());
    }

    private NecromancerData(List<ShadowData> storedShadows, double soulEnergy, int maxSoulEnergy, ConcurrentHashMap<ShadowData, class_1308> spawnedShadows) {
        this.storedShadows = storedShadows;
        this.soulEnergy = soulEnergy;
        this.maxSoulEnergy = maxSoulEnergy;
        this.spawnedShadows = spawnedShadows;
    }

    public NecromancerData copy() {
        NecromancerData copy = new NecromancerData(this.storedShadows, this.soulEnergy, this.maxSoulEnergy, this.spawnedShadows);
        copy.spawned = this.spawned;
        return copy;
    }

    private boolean toggleShadowsInternal(class_3222 player) {
        if (this.spawned) {
            this.despawnShadowsInternal(player.method_68878());
            return true;
        }
        return this.spawnShadowsInternal(player);
    }

    private boolean spawnShadowsInternal(class_3222 player) {
        for (ShadowData shadow : this.storedShadows) {
            if (!player.method_68878()) {
                if ((double)shadow.getEnergyCost() > this.soulEnergy) break;
                this.soulEnergy -= (double)shadow.getEnergyCost();
            }
            class_2338 spawnPos = player.method_24515().method_10069(-2 + player.method_59922().method_43048(5), 1, -2 + player.method_59922().method_43048(5));
            shadow.getEntityType().method_5899(player.method_51469(), spawned -> {
                if (spawned instanceof class_1308) {
                    class_1308 mobEntity = (class_1308)spawned;
                    shadow.onSpawn(mobEntity, player);
                    this.spawnedShadows.put(shadow, mobEntity);
                }
            }, spawnPos, class_3730.field_16461, false, false);
        }
        if (this.spawnedShadows.isEmpty()) {
            return false;
        }
        this.spawned = true;
        return true;
    }

    private void despawnShadowsInternal(boolean infiniteResources) {
        this.spawnedShadows.forEach((data, entity) -> this.despawnShadow(infiniteResources, (ShadowData)data));
        this.spawnedShadows.clear();
    }

    private void despawnShadow(boolean infiniteResources, ShadowData data) {
        class_1308 entity = this.spawnedShadows.get(data);
        if (entity == null) {
            return;
        }
        if (entity.method_5805() && !infiniteResources) {
            this.soulEnergy = Math.clamp(this.soulEnergy + (double)data.getEnergyCost(), 0.0, (double)this.maxSoulEnergy);
        }
        data.updateFrom(entity);
        this.spawnedShadows.remove(data);
        entity.method_5650(class_1297.class_5529.field_26999);
        if (this.spawnedShadows.isEmpty()) {
            this.spawned = false;
        }
    }

    private void releaseShadow(boolean infiniteResources, ShadowData shadow) {
        this.despawnShadow(infiniteResources, shadow);
        this.storedShadows.remove(shadow);
    }

    private List<ShadowData> releaseShadows(boolean infiniteResources) {
        this.despawnShadowsInternal(infiniteResources);
        List<ShadowData> allShadows = List.copyOf(this.storedShadows);
        this.storedShadows.clear();
        return allShadows;
    }

    private void convertShadow(ShadowData shadow, class_3222 player, class_1308 converted) {
        shadow.onSpawn(converted, player);
        this.spawnedShadows.put(shadow, converted);
    }

    public static boolean toggleShadows(class_3222 player) {
        return NecromancyAttachments.modifyNecromancerDataWithResult(player, data -> data.toggleShadowsInternal(player));
    }

    public static void despawnShadows(class_3222 player) {
        NecromancyAttachments.modifyNecromancerData(player, data -> data.despawnShadowsInternal(player.method_68878()));
    }

    public static void addShadow(class_3222 player, ShadowData shadow) {
        NecromancyAttachments.modifyNecromancerData(player, data -> data.storedShadows.add(shadow));
    }

    public static void addShadows(class_3222 player, List<ShadowData> shadows) {
        NecromancyAttachments.modifyNecromancerData(player, data -> data.storedShadows.addAll(shadows));
    }

    public static void releaseShadow(class_3222 player, ShadowData shadow) {
        NecromancyAttachments.modifyNecromancerData(player, data -> {
            data.despawnShadow(player.method_68878(), shadow);
            data.storedShadows.remove(shadow);
        });
    }

    public static List<ShadowData> releaseShadows(class_3222 player) {
        return NecromancyAttachments.modifyNecromancerDataWithResult(player, data -> data.releaseShadows(player.method_68878()));
    }

    public static ShadowData releaseFirstShadow(class_3222 player) {
        return NecromancyAttachments.modifyNecromancerDataWithResult(player, data -> {
            if (data.storedShadows.isEmpty()) {
                return null;
            }
            ShadowData firstShadow = data.storedShadows.remove(0);
            data.releaseShadow(player.method_68878(), firstShadow);
            return firstShadow;
        });
    }

    public static int storedAmount(class_3222 player) {
        return NecromancyAttachments.getNecromancerData((class_1657)player).storedShadows.size();
    }

    public static void convertShadow(ShadowData.Instance previous, class_1308 converted) {
        NecromancyAttachments.modifyNecromancerData(previous.owner(), data -> data.convertShadow(previous.shadow(), previous.owner(), converted));
    }

    public static double getEnergy(class_3222 player) {
        return NecromancyAttachments.getNecromancerData((class_1657)player).soulEnergy;
    }

    public static void setEnergy(class_3222 player, double amount) {
        NecromancyAttachments.modifyNecromancerData(player, data -> {
            data.soulEnergy = Math.clamp(amount, 0.0, (double)data.maxSoulEnergy);
        });
    }

    public static int getMaxEnergy(class_3222 player) {
        return NecromancyAttachments.getNecromancerData((class_1657)player).maxSoulEnergy;
    }

    public static void setMaxEnergy(class_3222 player, int amount) {
        NecromancyAttachments.modifyNecromancerData(player, data -> {
            data.maxSoulEnergy = Math.max(0, amount);
        });
    }

    public static void appendTotemTooltip(class_9473 components, class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type) {
        NecromancersShadow.LOCAL_PLAYER.get().ifPresent(player -> {
            NecromancerData data = NecromancyAttachments.getNecromancerData(player);
            textConsumer.accept((class_2561)class_2561.method_43471((String)SOUL_ENERGY_TRANSLATION_KEY).method_10852((class_2561)class_2561.method_43470((String)NecromancersShadow.DECIMAL_FORMAT.format(data.soulEnergy)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(data.maxSoulEnergy)).method_27692(class_124.field_1075)));
            ShadowData.appendShadowsTooltip(components, context, textConsumer, type, data.storedShadows);
        });
    }

    public static int getItemBarStep() {
        Optional<class_1657> player = NecromancersShadow.LOCAL_PLAYER.get();
        if (player.isPresent()) {
            NecromancerData data = NecromancyAttachments.getNecromancerData(player.get());
            float percentage = (float)data.soulEnergy / (float)data.maxSoulEnergy;
            return Math.clamp((long)Math.round(percentage * 13.0f), 0, 13);
        }
        return 0;
    }

    public static NecromancerData empty() {
        return new NecromancerData(List.of(), (Pair<Double, Integer>)Pair.of((Object)0.0, (Object)10));
    }
}

