/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.data;

import com.mojang.serialization.Codec;
import cz.yorick.data.NecromancerData;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentSyncPredicate;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_9135;

public class NecromancyAttachments {
    private static final AttachmentType<Boolean> IS_SHADOW = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"necromancers-shadow", (String)"is_shadow"), builder -> builder.copyOnDeath().persistent((Codec)Codec.BOOL).syncWith(class_9135.field_48547, AttachmentSyncPredicate.all()));
    private static final AttachmentType<NecromancerData> NECROMANCER_DATA = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"necromancers-shadow", (String)"necromancer_data"), builder -> builder.copyOnDeath().initializer(NecromancerData::empty).persistent(NecromancerData.CODEC).syncWith(NecromancerData.PACKET_CODEC, AttachmentSyncPredicate.targetOnly()));

    public static boolean isMarkedAsShadow(class_1297 entity) {
        return entity.hasAttached(IS_SHADOW);
    }

    public static void markAsShadow(class_1297 entity, boolean shadow) {
        if (shadow) {
            entity.setAttached(IS_SHADOW, (Object)true);
        } else {
            entity.removeAttached(IS_SHADOW);
        }
    }

    public static void modifyNecromancerData(class_3222 player, Consumer<NecromancerData> action) {
        NecromancyAttachments.modifyNecromancerDataWithResult(player, data -> {
            action.accept((NecromancerData)data);
            return 0;
        });
    }

    public static <T> T modifyNecromancerDataWithResult(class_3222 player, Function<NecromancerData, T> action) {
        NecromancerData data = (NecromancerData)player.getAttachedOrCreate(NECROMANCER_DATA);
        T result = action.apply(data);
        player.setAttached(NECROMANCER_DATA, (Object)data.copy());
        return result;
    }

    public static NecromancerData getNecromancerData(class_1657 player) {
        return (NecromancerData)player.getAttachedOrCreate(NECROMANCER_DATA);
    }

    public static void init() {
    }
}

