/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cz.yorick.NecromancersShadow;
import cz.yorick.data.NecromancyAttachments;
import cz.yorick.imixin.IMobEntityMixin;
import cz.yorick.imixin.IServerPlayerEntityMixin;
import cz.yorick.mixin.EntityAccessor;
import cz.yorick.util.Util;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import net.minecraft.class_9299;
import net.minecraft.class_9473;

public class ShadowData
implements class_9299 {
    public static final String STORED_SHADOWS_TRANSLATION_KEY = "tooltip.necromancers-shadow.stored_shadows";
    private static final MapCodec<ShadowData> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41177.method_39673().fieldOf("type").forGetter(ShadowData::getEntityType), (App)class_5699.field_33441.optionalFieldOf("energyCost").forGetter(data -> Optional.of(data.energyCost))).apply((Applicative)instance, (type, health) -> new ShadowData((class_1299<?>)type, health.orElse(Util.getAttribute(type, (class_6880<class_1320>)class_5134.field_23716)), new class_2487())));
    public static final Codec<ShadowData> SYNC_CODEC = MAP_CODEC.codec();
    public static final Codec<ShadowData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MAP_CODEC.forGetter(data -> data), (App)class_2487.field_25128.optionalFieldOf("data", (Object)new class_2487()).forGetter(shadow -> shadow.nbt)).apply((Applicative)instance, (data, nbt) -> {
        data.nbt = nbt;
        return data;
    }));
    private class_1299<?> entityType;
    private int energyCost;
    private class_2487 nbt;

    private ShadowData(class_1299<?> entityType, int energyCost, class_2487 nbt) {
        this.entityType = entityType;
        this.energyCost = energyCost;
        this.nbt = nbt;
    }

    public ShadowData(class_1308 entity) {
        this.updateFrom(entity);
    }

    public class_1299<?> getEntityType() {
        return this.entityType;
    }

    public int getEnergyCost() {
        return this.energyCost;
    }

    public void onSpawn(class_1308 vessel, class_3222 owner) {
        ((EntityAccessor)vessel).invokeReadCustomData(class_11352.method_71417((class_8942)NecromancersShadow.ERROR_REPORTER, (class_7225.class_7874)vessel.method_56673(), (class_2487)this.nbt.method_10553()));
        ((IMobEntityMixin)vessel).necromancers_shadow$setShadow(new Instance(this, owner));
        NecromancyAttachments.markAsShadow((class_1297)vessel, true);
    }

    public void updateFrom(class_1308 vessel) {
        class_11362 newNbt = class_11362.method_71459((class_8942)NecromancersShadow.ERROR_REPORTER, (class_7225.class_7874)vessel.method_56673());
        ((EntityAccessor)vessel).invokeWriteCustomData((class_11372)newNbt);
        newNbt.method_71478("Health");
        this.entityType = vessel.method_5864();
        this.energyCost = Math.round(vessel.method_6063());
        this.nbt = newNbt.method_71475();
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
        textConsumer.accept((class_2561)class_5250.method_43477((class_7417)this.entityType.method_5897().method_10851()).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)": [").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.energyCost)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1080)));
    }

    public static ShadowData empty() {
        return new ShadowData((class_1299)class_7923.field_41177.method_63535((class_2960)null), 0, new class_2487());
    }

    public static void appendShadowsTooltip(class_9473 components, class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, List<ShadowData> storedShadows) {
        textConsumer.accept((class_2561)class_2561.method_43471((String)STORED_SHADOWS_TRANSLATION_KEY));
        storedShadows.forEach(shadow -> shadow.method_57409(context, textConsumer, type, components));
    }

    public record Instance(ShadowData shadow, class_3222 owner) {
        public class_1309 getTarget() {
            return ((IServerPlayerEntityMixin)this.owner).necromancers_shadow$getTarget();
        }
    }
}

