/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.data;

import com.mojang.serialization.Codec;
import cz.yorick.NecromancersShadow;
import cz.yorick.data.ImmutableShadowStorage;
import cz.yorick.data.MutableShadowStorage;
import cz.yorick.data.ServerShadowManager;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentSyncPredicate;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_9135;
import net.minecraft.class_9473;

public class DataAttachments {
    public static final String SOUL_ENERGY_TRANSLATION_KEY = "tooltip.necromancers-shadow.soul_energy";
    private static final AttachmentType<Boolean> IS_SHADOW = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"necromancers-shadow", (String)"is_shadow"), builder -> builder.copyOnDeath().persistent((Codec)Codec.BOOL).syncWith(class_9135.field_48547, AttachmentSyncPredicate.all()));
    private static final AttachmentType<ImmutableShadowStorage> SHADOW_STORAGE = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"necromancers-shadow", (String)"shadow_storage"), builder -> builder.copyOnDeath().initializer(ImmutableShadowStorage::empty).persistent(ImmutableShadowStorage.CODEC).syncWith(class_9135.method_56896(ImmutableShadowStorage.SYNC_CODEC), AttachmentSyncPredicate.targetOnly()));
    private static final AttachmentType<ServerShadowManager> SHADOW_MANAGER = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"necromancers-shadow", (String)"shadow_manager"));
    private static final AttachmentType<Double> SOUL_ENERGY = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"necromancers-shadow", (String)"soul_energy"), builder -> builder.copyOnDeath().initializer(() -> 0.0).persistent((Codec)Codec.DOUBLE).syncWith(class_9135.field_48553, AttachmentSyncPredicate.targetOnly()));
    private static final AttachmentType<Integer> MAX_SOUL_ENERGY = AttachmentRegistry.create((class_2960)class_2960.method_60655((String)"necromancers-shadow", (String)"max_soul_energy"), builder -> builder.copyOnDeath().initializer(() -> 0).persistent((Codec)Codec.INT).syncWith(class_9135.field_49675, AttachmentSyncPredicate.targetOnly()));

    public static boolean isMarkedAsShadow(class_1297 entity) {
        return entity.hasAttached(IS_SHADOW);
    }

    public static void markAsShadow(class_1297 entity, boolean shadow) {
        if (shadow) {
            entity.setAttached(IS_SHADOW, (Object)true);
        } else {
            entity.removeAttached(IS_SHADOW);
        }
    }

    public static ImmutableShadowStorage getShadowStorage(class_1657 player) {
        return (ImmutableShadowStorage)player.getAttachedOrCreate(SHADOW_STORAGE);
    }

    public static void mutateShadowStorage(class_3222 player, Consumer<MutableShadowStorage> mutator) {
        MutableShadowStorage mutable = DataAttachments.getShadowStorage((class_1657)player).toMutable();
        mutator.accept(mutable);
        player.setAttached(SHADOW_STORAGE, (Object)mutable.toImmutable());
    }

    public static ServerShadowManager getShadowManager(class_3222 player) {
        return (ServerShadowManager)player.getAttachedOrCreate(SHADOW_MANAGER, () -> new ServerShadowManager(player));
    }

    public static double getSoulEnergy(class_1657 player) {
        return (Double)player.getAttachedOrCreate(SOUL_ENERGY);
    }

    public static void setSoulEnergy(class_3222 player, double amount) {
        player.setAttached(SOUL_ENERGY, (Object)amount);
    }

    public static void addSoulEnergy(class_3222 player, double amount) {
        player.modifyAttached(SOUL_ENERGY, originalAmount -> originalAmount + amount);
    }

    public static void removeSoulEnergy(class_3222 player, double amount) {
        DataAttachments.addSoulEnergy(player, -amount);
    }

    public static int getMaxSoulEnergy(class_1657 player) {
        return (Integer)player.getAttachedOrCreate(MAX_SOUL_ENERGY);
    }

    public static void setMaxSoulEnergy(class_3222 player, int amount) {
        player.setAttached(MAX_SOUL_ENERGY, (Object)amount);
    }

    public static int getSoulEnergyItemBarStep() {
        return NecromancersShadow.LOCAL_PLAYER.get().map(player -> {
            double percentage = DataAttachments.getSoulEnergy(player) / (double)DataAttachments.getMaxSoulEnergy(player);
            return Math.clamp(Math.round(percentage * 13.0), 0, 13);
        }).orElse(0);
    }

    public static void appendEnergyTooltip(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
        NecromancersShadow.LOCAL_PLAYER.get().ifPresent(player -> {
            textConsumer.accept((class_2561)class_2561.method_43471((String)SOUL_ENERGY_TRANSLATION_KEY).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)NecromancersShadow.DECIMAL_FORMAT.format(DataAttachments.getSoulEnergy(player))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(DataAttachments.getMaxSoulEnergy(player))).method_27692(class_124.field_1075)));
            DataAttachments.getShadowStorage(player).method_57409(context, textConsumer, type, components);
        });
    }

    public static void init() {
    }
}

