/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.data;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import cz.yorick.data.MutableShadowStorage;
import cz.yorick.data.ShadowAccess;
import cz.yorick.data.ShadowData;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5699;
import net.minecraft.class_9299;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;

public class ImmutableShadowStorage
implements class_9299,
Iterable<Map.Entry<Integer, ShadowData>>,
ShadowAccess {
    public static final String STORED_SHADOWS_TRANSLATION_KEY = "tooltip.necromancers-shadow.stored_shadows";
    private static final Codec<Integer> STRINGIFIED_INT_CODEC = class_5699.field_41759.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)Integer.parseInt(string));
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Not a number: '" + string + "'");
        }
    }, String::valueOf);
    public static final Codec<ImmutableShadowStorage> CODEC = ImmutableShadowStorage.buildCodec(ShadowData.CODEC);
    public static final Codec<ImmutableShadowStorage> SYNC_CODEC = ImmutableShadowStorage.buildCodec(ShadowData.SYNC_CODEC);
    private final ImmutableMap<Integer, ShadowData> shadows;

    private static Codec<ImmutableShadowStorage> buildCodec(Codec<ShadowData> shadowDataCodec) {
        return Codec.unboundedMap(STRINGIFIED_INT_CODEC, shadowDataCodec).xmap(ImmutableShadowStorage::new, storage -> storage.shadows);
    }

    public ImmutableShadowStorage(Map<Integer, ShadowData> shadows) {
        this.shadows = ImmutableMap.copyOf(shadows);
    }

    public MutableShadowStorage toMutable() {
        return new MutableShadowStorage((Int2ObjectMap<ShadowData>)new Int2ObjectArrayMap(this.shadows));
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
        textConsumer.accept((class_2561)class_2561.method_43471((String)STORED_SHADOWS_TRANSLATION_KEY).method_27692(class_124.field_1080));
        this.shadows.forEach((slot, shadow) -> textConsumer.accept(shadow.asText()));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<Integer, ShadowData>> iterator() {
        return this.shadows.entrySet().iterator();
    }

    @Override
    public ShadowData getShadow(int slot) {
        return (ShadowData)this.shadows.get((Object)slot);
    }

    @Override
    public int lastOccupiedSlot() {
        return this.shadows.keySet().stream().mapToInt(Integer::intValue).max().orElse(0);
    }

    @Override
    public boolean isEmpty() {
        return this.shadows.isEmpty();
    }

    public static ImmutableShadowStorage empty() {
        return new ImmutableShadowStorage(Map.of());
    }
}

