/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.data;

import cz.yorick.data.ImmutableShadowStorage;
import cz.yorick.data.MutableShadowAccess;
import cz.yorick.data.ShadowData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;

public class MutableShadowStorage
implements MutableShadowAccess {
    private final Int2ObjectMap<ShadowData> shadows;

    public MutableShadowStorage(Int2ObjectMap<ShadowData> shadows) {
        this.shadows = shadows;
    }

    @Override
    public ShadowData getShadow(int slot) {
        return (ShadowData)this.shadows.get(slot);
    }

    @Override
    public void setShadow(int slot, ShadowData data) {
        if (data == null) {
            this.shadows.remove(slot);
            return;
        }
        this.shadows.put(slot, (Object)data);
    }

    @Override
    public int lastOccupiedSlot() {
        return this.shadows.keySet().intStream().max().orElse(0);
    }

    public void addShadow(ShadowData shadowData) {
        this.setShadow(this.firstFreeSlot(), shadowData);
    }

    public int firstFreeSlot() {
        IntSet takenSlots = this.shadows.keySet();
        int i = 0;
        while (takenSlots.contains(i)) {
            ++i;
        }
        return i;
    }

    @Override
    public boolean isEmpty() {
        return this.shadows.isEmpty();
    }

    public ImmutableShadowStorage toImmutable() {
        return new ImmutableShadowStorage((Map<Integer, ShadowData>)this.shadows);
    }

    public String toString() {
        CharSequence[] converted = new String[this.shadows.size()];
        int index = 0;
        for (Int2ObjectMap.Entry shadowDataEntry : this.shadows.int2ObjectEntrySet()) {
            converted[index] = shadowDataEntry.getIntKey() + ":" + ((ShadowData)shadowDataEntry.getValue()).simpleToString();
            ++index;
        }
        return "ShadowStorage{shadows=[" + String.join((CharSequence)", ", converted) + "]}";
    }
}

