/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.data;

import cz.yorick.NecromancersShadow;
import cz.yorick.data.DataAttachments;
import cz.yorick.data.ImmutableShadowStorage;
import cz.yorick.data.MutableShadowAccess;
import cz.yorick.data.MutableShadowStorage;
import cz.yorick.data.ShadowData;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3730;

public class ServerShadowManager
implements MutableShadowAccess {
    private final class_3222 owner;
    private final Int2ObjectMap<class_1308> spawned = new Int2ObjectArrayMap();

    public ServerShadowManager(class_3222 owner) {
        this.owner = owner;
    }

    private boolean shouldHandleResources() {
        return !this.owner.method_68878();
    }

    private boolean toggleShadowsInternal() {
        if (this.spawned.isEmpty()) {
            return this.trySpawnShadows();
        }
        this.despawnShadows();
        return true;
    }

    private boolean trySpawnShadows() {
        int spawned = 0;
        for (Map.Entry<Integer, ShadowData> shadowDataEntry : DataAttachments.getShadowStorage((class_1657)this.owner)) {
            if (!this.trySpawnShadow(shadowDataEntry.getKey(), shadowDataEntry.getValue())) continue;
            ++spawned;
        }
        return spawned > 0;
    }

    private boolean trySpawnShadow(int slot, ShadowData shadow) {
        if (this.spawned.containsKey(slot)) {
            return false;
        }
        if (this.shouldHandleResources()) {
            if ((double)shadow.cost() > DataAttachments.getSoulEnergy((class_1657)this.owner)) {
                return false;
            }
            DataAttachments.removeSoulEnergy(this.owner, shadow.cost());
        }
        class_2338 spawnPos = this.owner.method_24515().method_10069(-2 + this.owner.method_59922().method_43048(5), 1, -2 + this.owner.method_59922().method_43048(5));
        shadow.entityType().method_5899(this.owner.method_51469(), spawned -> {
            if (spawned instanceof class_1308) {
                class_1308 mobEntity = (class_1308)spawned;
                shadow.applyTo(mobEntity, this.owner);
                this.spawned.put(slot, (Object)mobEntity);
            }
        }, spawnPos, class_3730.field_16461, false, false);
        return true;
    }

    public void despawnShadows() {
        if (this.spawned.isEmpty()) {
            return;
        }
        this.mutateStorage(mutableStorage -> {
            for (int slot : this.spawned.keySet().toIntArray()) {
                this.tryDespawnShadow((MutableShadowStorage)mutableStorage, slot);
            }
        });
    }

    private void tryDespawnShadow(MutableShadowStorage mutableStorage, int slot) {
        class_1308 spawnedEntity = (class_1308)this.spawned.get(slot);
        if (spawnedEntity == null) {
            return;
        }
        ShadowData data = ShadowData.fromEntity(spawnedEntity);
        if (spawnedEntity.method_5805() && this.shouldHandleResources()) {
            DataAttachments.addSoulEnergy(this.owner, data.cost());
        }
        spawnedEntity.method_5650(class_1297.class_5529.field_26999);
        this.spawned.remove(slot);
        mutableStorage.setShadow(slot, data);
    }

    private void mutateStorage(Consumer<MutableShadowStorage> mutator) {
        DataAttachments.mutateShadowStorage(this.owner, mutator);
    }

    public void convertShadow(class_1308 oldEntity, class_1308 newEntity) {
        int slot = this.findSlot(oldEntity);
        if (slot <= -1) {
            NecromancersShadow.LOGGER.warn("findSlot returned -1 when called from convertShadow, should never happen");
            return;
        }
        this.spawned.put(slot, (Object)newEntity);
    }

    private int findSlot(class_1308 entity) {
        for (Int2ObjectMap.Entry mobEntityEntry : this.spawned.int2ObjectEntrySet()) {
            if (mobEntityEntry.getValue() != entity) continue;
            return mobEntityEntry.getIntKey();
        }
        return -1;
    }

    @Override
    public void swapShadows(int from, int to) {
        this.mutateStorage(mutableStorage -> {
            ShadowData toShadowData = mutableStorage.getShadow(to);
            mutableStorage.setShadow(to, mutableStorage.getShadow(from));
            mutableStorage.setShadow(from, toShadowData);
        });
        class_1308 fromEntity = (class_1308)this.spawned.remove(from);
        class_1308 toEntity = (class_1308)this.spawned.remove(to);
        if (fromEntity != null) {
            this.spawned.put(to, (Object)fromEntity);
        }
        if (toEntity != null) {
            this.spawned.put(from, (Object)toEntity);
        }
    }

    private ImmutableShadowStorage storage() {
        return DataAttachments.getShadowStorage((class_1657)this.owner);
    }

    @Override
    public ShadowData getShadow(int slot) {
        return this.storage().getShadow(slot);
    }

    @Override
    public void setShadow(int slot, ShadowData shadowData) {
        this.mutateStorage(mutableStorage -> {
            this.tryDespawnShadow((MutableShadowStorage)mutableStorage, slot);
            mutableStorage.setShadow(slot, shadowData);
        });
    }

    @Override
    public int lastOccupiedSlot() {
        return this.storage().lastOccupiedSlot();
    }

    @Override
    public boolean isEmpty() {
        return this.storage().isEmpty();
    }

    public void toggleShadow(int slot) {
        if (this.spawned.containsKey(slot)) {
            this.mutateStorage(mutableStorage -> this.tryDespawnShadow((MutableShadowStorage)mutableStorage, slot));
            return;
        }
        ShadowData shadow = DataAttachments.getShadowStorage((class_1657)this.owner).getShadow(slot);
        if (shadow == null) {
            return;
        }
        this.trySpawnShadow(slot, shadow);
    }

    public static boolean toggleShadows(class_3222 player) {
        return DataAttachments.getShadowManager(player).toggleShadowsInternal();
    }
}

