/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.yorick.data.DataAttachments;
import cz.yorick.data.ShadowData;
import cz.yorick.imixin.IMobEntityMixin;
import cz.yorick.mixin.BrainAccessor;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1338;
import net.minecraft.class_1355;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_4168;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_7893;
import net.minecraft.class_8046;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1308.class})
public abstract class MobEntityMixin
extends class_1309
implements IMobEntityMixin {
    @Unique
    private ShadowData.Instance shadowInstance = null;
    @Unique
    private static final Supplier<class_7893<class_1308>> SIMPLE_TARGET_TASK_FACTORY = () -> class_4824.method_47119((world, entity) -> Optional.ofNullable(entity.method_5968()));
    @Unique
    private static final Function<class_3222, class_7893<class_1308>> SIMPLE_FORGET_TARGET_TASK_FACTORY = owner -> class_4828.method_47139((world, target) -> target != owner.method_6052(), (world, entity, target) -> {}, (boolean)false);
    @Shadow
    @Final
    protected class_1355 field_6201;
    @Shadow
    @Final
    protected class_1355 field_6185;

    protected MobEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow
    public abstract class_1309 method_5968();

    @Override
    public void necromancers_shadow$setShadow(ShadowData.Instance shadowInstance) {
        this.shadowInstance = shadowInstance;
        this.field_6185.method_35113(goal -> true);
        this.field_6201.method_35113(goal -> goal instanceof class_1338);
        this.modifyBrain();
    }

    @Unique
    private void modifyBrain() {
        Map<Integer, Map<class_4168, Set<class_7893<? extends class_1309>>>> brainTasks = ((BrainAccessor)this.method_18868()).getTasks();
        if (brainTasks.isEmpty()) {
            return;
        }
        TreeMap newBrainTasks = Maps.newTreeMap();
        for (Map.Entry<Integer, Map<class_4168, Set<class_7893<? extends class_1309>>>> mainEntry : brainTasks.entrySet()) {
            HashMap newActivities = Maps.newHashMap();
            for (Map.Entry<class_4168, Set<class_7893<? extends class_1309>>> activityEntry : mainEntry.getValue().entrySet()) {
                LinkedHashSet newTasks = Sets.newLinkedHashSet();
                for (class_7893<? extends class_1309> task : activityEntry.getValue()) {
                    if (task.method_46910().contains(class_4824.class.getName())) {
                        newTasks.add(SIMPLE_TARGET_TASK_FACTORY.get());
                        continue;
                    }
                    if (task.method_46910().contains(class_4828.class.getName())) {
                        newTasks.add(SIMPLE_FORGET_TARGET_TASK_FACTORY.apply(this.shadowInstance.owner()));
                        continue;
                    }
                    newTasks.add(task);
                }
                newActivities.put(activityEntry.getKey(), newTasks);
            }
            newBrainTasks.put(mainEntry.getKey(), newActivities);
        }
        brainTasks.clear();
        brainTasks.putAll(newBrainTasks);
    }

    @Override
    public ShadowData.Instance necromancers_shadow$$getShadowInstance() {
        return this.shadowInstance;
    }

    @Inject(method={"getTarget", "getTargetInBrain"}, at={@At(value="HEAD")}, cancellable=true)
    private void necromancers_shadow$getOwnerTarget(CallbackInfoReturnable<class_1309> cir) {
        class_8046 ownable;
        MobEntityMixin mobEntityMixin;
        if (this.shadowInstance != null) {
            cir.setReturnValue((Object)this.shadowInstance.getTarget());
        } else if (DataAttachments.isMarkedAsShadow((class_1297)this) && (mobEntityMixin = this) instanceof class_8046 && (mobEntityMixin = (ownable = (class_8046)mobEntityMixin).method_24921()) instanceof class_1308) {
            class_1308 mobEntity = (class_1308)mobEntityMixin;
            cir.setReturnValue((Object)mobEntity.method_5968());
        }
    }
}

