/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.screen;

import cz.yorick.networking.NecromancerInventorySwapC2SPacket;
import cz.yorick.screen.NecromancerInventoryScreenHandler;
import cz.yorick.screen.widget.ShadowAccessWidget;
import cz.yorick.screen.widget.ShadowPreviewWidget;
import cz.yorick.screen.widget.SilentButtonWidget;
import cz.yorick.screen.widget.SoulSlotWidget;
import cz.yorick.screen.widget.ToggleSummonWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class NecromancerInventoryScreen
extends class_465<NecromancerInventoryScreenHandler> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"necromancers-shadow", (String)"textures/gui/player_inventory.png");
    private final ShadowAccessWidget storageWidget;
    private final ShadowPreviewWidget previewWidget = new ShadowPreviewWidget(70, 70);
    private final SilentButtonWidget deleteWidget = new SilentButtonWidget(18, 18, this::deletePickedUp);
    private final ToggleSummonWidget toggleSummonWidget = new ToggleSummonWidget(this::togglePreviewedSummon);
    private int pickedUp = -1;

    public NecromancerInventoryScreen(NecromancerInventoryScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.storageWidget = new ShadowAccessWidget(((NecromancerInventoryScreenHandler)this.method_17577()).getPlayerShadows(), this::onClicked);
        this.field_25268 += 77;
    }

    protected void method_25426() {
        super.method_25426();
        this.previewWidget.method_48229(this.field_2776 + 8, this.field_2800 + 8);
        this.method_37063((class_364)this.previewWidget);
        this.deleteWidget.method_48229(this.field_2776 + this.field_2792 - 7 - 18, this.field_2800 + 7);
        this.method_37063((class_364)this.deleteWidget);
        this.toggleSummonWidget.method_48229(this.field_2776 + this.field_2792 - 7 - 18 - 1, this.field_2800 + 58);
        this.storageWidget.method_73369(this.field_2792 - 14 - 18, 63, this.field_2776 + 7, this.field_2800 + 18 + 70 + 7);
        this.method_37063((class_364)this.storageWidget);
    }

    protected void method_2389(class_332 context, float deltaTicks, int mouseX, int mouseY) {
        context.method_25290(class_10799.field_56883, TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, -12566464, false);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        if (this.pickedUp >= 0) {
            context.method_25290(class_10799.field_56883, SoulSlotWidget.SOUL_TEXTURE, mouseX - 8, mouseY - 8, 0.0f, 0.0f, 16, 16, 16, 16);
            context.method_71276(this.storageWidget.getWidgetFor(this.pickedUp).method_25369(), mouseX, mouseY);
            return;
        }
        this.method_19355(mouseX, mouseY).ifPresent(hoveredMain -> {
            ToggleSummonWidget toggleWidget;
            if (hoveredMain instanceof ShadowAccessWidget) {
                ShadowAccessWidget hoveredStorage = (ShadowAccessWidget)((Object)hoveredMain);
                hoveredStorage.method_19355(mouseX, mouseY).ifPresent(hoveredEntry -> {
                    if (hoveredEntry instanceof ShadowAccessWidget.Entry) {
                        ShadowAccessWidget.Entry entry = (ShadowAccessWidget.Entry)((Object)((Object)hoveredEntry));
                        entry.method_19355(mouseX, mouseY).ifPresent(hoveredElement -> {
                            SoulSlotWidget dataWidget;
                            if (hoveredElement instanceof SoulSlotWidget && (dataWidget = (SoulSlotWidget)((Object)((Object)((Object)hoveredElement)))).getShadowData() != null) {
                                context.method_71276(dataWidget.method_25369(), mouseX, mouseY);
                            }
                        });
                    }
                });
            } else if (hoveredMain instanceof ToggleSummonWidget && (toggleWidget = (ToggleSummonWidget)((Object)hoveredMain)).method_25369() != null) {
                context.method_71276(toggleWidget.method_25369(), mouseX, mouseY);
            }
        });
    }

    private void onClicked(class_11909 click, SoulSlotWidget clicked) {
        if (click.method_74245() == 0) {
            this.onLeftClick(clicked);
            return;
        }
        if (click.method_74245() == 1) {
            if (clicked.isEmpty()) {
                this.method_37066((class_364)this.toggleSummonWidget);
            } else if (!this.previewWidget.isActive()) {
                this.method_37063((class_364)this.toggleSummonWidget);
            }
            this.previewWidget.setPreviewed(clicked.getId(), clicked.getShadowData(), (class_1937)this.field_22787.field_1687);
        }
    }

    private void onLeftClick(SoulSlotWidget clicked) {
        if (this.pickedUp < 0) {
            if (!clicked.isEmpty()) {
                clicked.setPickedUp(true);
                this.pickedUp = clicked.getId();
            }
            return;
        }
        if (this.pickedUp == clicked.getId()) {
            this.storageWidget.getWidgetFor(this.pickedUp).setPickedUp(false);
            this.pickedUp = -1;
            return;
        }
        SoulSlotWidget pickedUpWidget = this.storageWidget.getWidgetFor(this.pickedUp);
        ((NecromancerInventoryScreenHandler)this.method_17577()).getPlayerShadows().swapShadows(this.pickedUp, clicked.getId());
        ClientPlayNetworking.send((class_8710)new NecromancerInventorySwapC2SPacket(this.pickedUp, clicked.getId()));
        this.previewWidget.onSwap(this.pickedUp, clicked.getId());
        if (clicked.isEmpty()) {
            pickedUpWidget.setPickedUp(false);
            this.pickedUp = -1;
        }
        this.storageWidget.refreshEntries(((NecromancerInventoryScreenHandler)this.method_17577()).getPlayerShadows());
        if (this.pickedUp >= 0) {
            this.storageWidget.getWidgetFor(this.pickedUp).setPickedUp(true);
        }
    }

    private void deletePickedUp() {
        if (this.pickedUp >= 0) {
            ((NecromancerInventoryScreenHandler)this.method_17577()).getPlayerShadows().setShadow(this.pickedUp, null);
            ClientPlayNetworking.send((class_8710)new NecromancerInventorySwapC2SPacket(this.pickedUp, -2));
            if (this.pickedUp == this.previewWidget.getPreviewedId()) {
                this.previewWidget.clearPreview();
            }
            this.pickedUp = -1;
            this.storageWidget.refreshEntries(((NecromancerInventoryScreenHandler)this.method_17577()).getPlayerShadows());
        }
    }

    private void togglePreviewedSummon() {
        ClientPlayNetworking.send((class_8710)new NecromancerInventorySwapC2SPacket(this.previewWidget.getPreviewedId(), -1));
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.method_19355(mouseX, mouseY).map(element -> element.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)).orElseGet(() -> super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount));
    }
}

