/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.screen;

import cz.yorick.data.DataAttachments;
import cz.yorick.data.MutableShadowStorage;
import cz.yorick.networking.SculkEmeraldInventorySwapC2SPacket;
import cz.yorick.screen.widget.ShadowAccessWidget;
import cz.yorick.screen.widget.SoulSlotWidget;
import cz.yorick.util.UiId;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class SculkEmeraldScreen
extends class_437 {
    public static String TITLE_TRANSLATION_KEY = "title.necromancers-shadow.sculk_emerald_inventory";
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"necromancers-shadow", (String)"textures/gui/sculk_emerald_inventory.png");
    private static final int backgroundWidth = 176;
    private static final int backgroundHeight = 222;
    private static final int titleX = 8;
    private static final int titleY = 6;
    private static final int title2Y = 114;
    private int x = 0;
    private int y = 0;
    private final MutableShadowStorage playerStorage;
    private final MutableShadowStorage itemStorage;
    private final ShadowAccessWidget playerStorageWidget;
    private final ShadowAccessWidget itemStorageWidget;
    private final class_2561 title2;
    private UiId pickedUp = null;

    public SculkEmeraldScreen(MutableShadowStorage itemStorage) {
        super((class_2561)class_2561.method_43471((String)TITLE_TRANSLATION_KEY));
        this.playerStorage = DataAttachments.getShadowStorage((class_1657)class_310.method_1551().field_1724).toMutable();
        this.itemStorage = itemStorage;
        this.playerStorageWidget = new ShadowAccessWidget(this.playerStorage, (click, soulSlotWidget) -> this.onClicked((SoulSlotWidget)((Object)soulSlotWidget), UiId.Ui.PLAYER, click.method_74239()));
        this.itemStorageWidget = new ShadowAccessWidget(this.itemStorage, (click, soulSlotWidget) -> this.onClicked((SoulSlotWidget)((Object)soulSlotWidget), UiId.Ui.ITEM, click.method_74239()));
        this.title2 = class_2561.method_43471((String)"title.necromancers-shadow.necromancer_inventory");
    }

    protected void method_25426() {
        this.x = (this.field_22789 - 176) / 2;
        this.y = (this.field_22790 - 222) / 2;
        this.itemStorageWidget.method_73369(144, 90, this.x + 7, this.y + 18);
        this.method_37063((class_364)this.itemStorageWidget);
        this.playerStorageWidget.method_73369(144, 90, this.x + 7, this.y + 18 + 90 + 18);
        this.method_37063((class_364)this.playerStorageWidget);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25420(context, mouseX, mouseY, deltaTicks);
        context.method_25290(class_10799.field_56883, TEXTURE, this.x, this.y, 0.0f, 0.0f, 176, 222, 256, 256);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        context.method_51439(this.field_22793, this.field_22785, this.x + 8, this.y + 6, -12566464, false);
        context.method_51439(this.field_22793, this.title2, this.x + 8, this.y + 114, -12566464, false);
        if (this.pickedUp != null) {
            context.method_25290(class_10799.field_56883, SoulSlotWidget.SOUL_TEXTURE, mouseX - 8, mouseY - 8, 0.0f, 0.0f, 16, 16, 16, 16);
            context.method_71276(this.getWidget(this.pickedUp).method_25369(), mouseX, mouseY);
            return;
        }
        this.method_19355(mouseX, mouseY).ifPresent(hoveredMain -> {
            if (hoveredMain instanceof ShadowAccessWidget) {
                ShadowAccessWidget hoveredStorage = (ShadowAccessWidget)((Object)hoveredMain);
                hoveredStorage.method_19355(mouseX, mouseY).ifPresent(hoveredEntry -> {
                    if (hoveredEntry instanceof ShadowAccessWidget.Entry) {
                        ShadowAccessWidget.Entry entry = (ShadowAccessWidget.Entry)((Object)((Object)hoveredEntry));
                        entry.method_19355(mouseX, mouseY).ifPresent(hoveredElement -> {
                            SoulSlotWidget dataWidget;
                            if (hoveredElement instanceof SoulSlotWidget && (dataWidget = (SoulSlotWidget)((Object)((Object)((Object)hoveredElement)))).getShadowData() != null) {
                                context.method_71276(dataWidget.method_25369(), mouseX, mouseY);
                            }
                        });
                    }
                });
            }
        });
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(class_11908 input) {
        if (super.method_25404(input)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(input)) {
            this.method_25419();
            return true;
        }
        return false;
    }

    private void onClicked(SoulSlotWidget clickedWidget, UiId.Ui ui, boolean hasShift) {
        UiId clicked = new UiId(ui, clickedWidget.getId());
        if (!clickedWidget.isEmpty() && hasShift) {
            UiId.Ui otherUi = clicked.ui().choose(UiId.Ui.ITEM, UiId.Ui.PLAYER);
            MutableShadowStorage otherStorage = otherUi.choose(this.playerStorage, this.itemStorage);
            UiId destination = new UiId(otherUi, otherStorage.firstFreeSlot());
            UiId.swap(clicked, destination, this.playerStorage, this.itemStorage);
            ClientPlayNetworking.send((class_8710)new SculkEmeraldInventorySwapC2SPacket(clicked, destination));
            this.refreshStorageWidgets();
            return;
        }
        if (this.pickedUp == null) {
            if (!clickedWidget.isEmpty()) {
                clickedWidget.setPickedUp(true);
                this.pickedUp = clicked;
            }
            return;
        }
        if (clicked.equals(this.pickedUp)) {
            this.getWidget(this.pickedUp).setPickedUp(false);
            this.pickedUp = null;
            return;
        }
        SoulSlotWidget pickedUpWidget = this.getWidget(this.pickedUp);
        pickedUpWidget.setPickedUp(false);
        UiId.swap(this.pickedUp, clicked, this.playerStorage, this.itemStorage);
        ClientPlayNetworking.send((class_8710)new SculkEmeraldInventorySwapC2SPacket(this.pickedUp, clicked));
        if (clickedWidget.isEmpty()) {
            clickedWidget.setPickedUp(false);
            this.pickedUp = null;
        }
        this.refreshStorageWidgets();
    }

    private void refreshStorageWidgets() {
        this.playerStorageWidget.refreshEntries(this.playerStorage);
        this.itemStorageWidget.refreshEntries(this.itemStorage);
        if (this.pickedUp != null) {
            this.getWidget(this.pickedUp).setPickedUp(true);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.method_19355(mouseX, mouseY).map(element -> element.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)).orElseGet(() -> super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount));
    }

    private SoulSlotWidget getWidget(UiId uiId) {
        return switch (uiId.ui()) {
            default -> throw new MatchException(null, null);
            case UiId.Ui.PLAYER -> this.playerStorageWidget.getWidgetFor(uiId.slot());
            case UiId.Ui.ITEM -> this.itemStorageWidget.getWidgetFor(uiId.slot());
        };
    }
}

