/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.screen.widget;

import cz.yorick.NecromancersShadow;
import cz.yorick.NecromancersShadowClient;
import cz.yorick.data.DataAttachments;
import cz.yorick.data.ShadowData;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1144;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_6382;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ShadowPreviewWidget
extends class_339 {
    public static final String HELP_TRANSLATION_KEY = "tooltip.necromancers-shadow.preview_help";
    public static final String TYPE_TRANSLATION_KEY = "tooltip.necromancers-shadow.type";
    public static final String SUMMON_COST_TRANSLATION_KEY = "tooltip.necromancers-shadow.summon_cost";
    public static final String HEALTH_TRANSLATION_KEY = "tooltip.necromancers-shadow.health";
    public static final String DAMAGE_TRANSLATION_KEY = "tooltip.necromancers-shadow.damage";
    private static final double ROTATION_CONSTANT = 0.05;
    private static final float SCALING_CONSTANT = 2.0f;
    private static final float MIN_SCALE = 1.0f;
    private static final float DEFAULT_SCALE = 16.0f;
    private static final float MAX_SCALE = 64.0f;
    private int previewedId = -1;
    private class_1297 entity = null;
    private Quaternionf rotation;
    private float scale = 16.0f;
    private final ArrayList<class_2561> aboutText = new ArrayList();

    public ShadowPreviewWidget(int width, int height) {
        super(0, 0, width, height, (class_2561)class_2561.method_43473());
        this.clearPreview();
    }

    public void clearPreview() {
        this.setPreviewed(-1, null, null);
    }

    public boolean isActive() {
        return this.entity != null;
    }

    public void onSwap(int from, int to) {
        if (this.previewedId == from) {
            this.previewedId = to;
        } else if (this.previewedId == to) {
            this.previewedId = from;
        }
    }

    public void setPreviewed(int id, ShadowData shadowData, class_1937 world) {
        this.aboutText.clear();
        if (shadowData == null) {
            this.entity = null;
            this.previewedId = 1;
            NecromancersShadowClient.decodeMultiline(HELP_TRANSLATION_KEY, this.aboutText::add);
            return;
        }
        this.rotation = new Quaternionf().rotateZ((float)Math.PI).rotateY(2.6f);
        this.previewedId = id;
        this.entity = shadowData.entityType().method_5883(world, class_3730.field_16461);
        class_11368 readView = class_11352.method_71417((class_8942)NecromancersShadow.ERROR_REPORTER, (class_7225.class_7874)class_310.method_1551().field_1724.method_56673(), (class_2487)shadowData.nbt());
        this.entity.method_5651(readView);
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            readView.method_71426("attributes", class_1324.class_11345.field_60358).ifPresent(packedAttributes -> livingEntity.method_6127().method_71381(packedAttributes));
        }
        DataAttachments.markAsShadow(this.entity, false);
        float widthScale = (float)(this.method_25368() - 10) / this.entity.method_17681();
        float heightScale = (float)(this.method_25364() - 10) / this.entity.method_17682();
        this.scale = Math.min(widthScale, heightScale);
        this.aboutText.add(this.entity.method_5477());
        this.aboutText.add((class_2561)class_2561.method_43470((String)""));
        this.aboutText.add((class_2561)class_2561.method_43471((String)TYPE_TRANSLATION_KEY).method_10852(shadowData.typeName()));
        this.aboutText.add((class_2561)class_2561.method_43471((String)SUMMON_COST_TRANSLATION_KEY).method_10852(shadowData.costText()));
        class_1297 class_12973 = this.entity;
        if (class_12973 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12973;
            this.aboutText.add((class_2561)class_2561.method_43471((String)HEALTH_TRANSLATION_KEY).method_10852((class_2561)class_2561.method_43470((String)NecromancersShadow.DECIMAL_FORMAT.format(livingEntity.method_6063())).method_27692(class_124.field_1061)));
            if (livingEntity.method_5996(class_5134.field_23721) != null) {
                this.aboutText.add((class_2561)class_2561.method_43471((String)DAMAGE_TRANSLATION_KEY).method_10852((class_2561)class_2561.method_43470((String)NecromancersShadow.DECIMAL_FORMAT.format(livingEntity.method_45325(class_5134.field_23721))).method_27692(class_124.field_1060)));
            }
        }
    }

    public int getPreviewedId() {
        return this.previewedId;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        if (this.entity != null) {
            class_898 entityRenderManager = class_310.method_1551().method_1561();
            class_897 entityRenderer = entityRenderManager.method_3953(this.entity);
            class_10017 entityRenderState = entityRenderer.method_62425(this.entity, 1.0f);
            entityRenderState.field_61820 = 0xF000F0;
            entityRenderState.field_58169 = null;
            entityRenderState.field_61823.clear();
            entityRenderState.field_61821 = 0;
            context.method_70856(entityRenderState, this.scale, new Vector3f().add(0.0f, 2.2f * (16.0f / this.scale), 0.0f), this.rotation, new Quaternionf(), this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());
        }
        for (int i = 0; i < this.aboutText.size(); ++i) {
            context.method_51439(class_310.method_1551().field_1772, this.aboutText.get(i), this.method_55442() + 4, this.method_46427() + 10 + 8 * i, -12566464, false);
        }
    }

    public void method_25354(class_1144 soundManager) {
    }

    protected void method_25349(class_11909 click, double offsetX, double offsetY) {
        this.rotation.rotateLocalY((float)(-offsetX * 0.05));
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.method_49606()) {
            this.scale = (float)Math.clamp((double)this.scale + verticalAmount * 2.0, 1.0, 64.0);
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 builder) {
    }
}

