/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import cz.yorick.NecromancersShadow;
import cz.yorick.data.NecromancyAttachments;
import cz.yorick.mixin.client.RenderLayerMultiPhaseAccessor;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.FabricRenderState;
import net.fabricmc.fabric.api.client.rendering.v1.RenderStateDataKey;
import net.minecraft.class_10042;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_9848;

@Environment(value=EnvType.CLIENT)
public class ShadowRenderHelper {
    public static RenderStateDataKey<Boolean> IS_SHADOW_RENDER_STATE_DATA = RenderStateDataKey.create(() -> "isShadow");
    private static final Function<class_1921, class_1921> TRANSPARENT_CONVERTER = class_156.method_34866(originalLayer -> {
        if (originalLayer instanceof RenderLayerMultiPhaseAccessor) {
            RenderLayerMultiPhaseAccessor multiPhase = (RenderLayerMultiPhaseAccessor)originalLayer;
            return class_1921.method_24049((String)(originalLayer.method_68484() + "_translucent_generated"), (int)originalLayer.method_22722(), (boolean)originalLayer.method_23037(), (boolean)true, (RenderPipeline)new TransparentRenderPipeline(multiPhase.getPipeline()), (class_1921.class_4688)multiPhase.getPhases());
        }
        NecromancersShadow.LOGGER.error("Found non-multiphase layer, it will not get rendered as transparent!");
        return originalLayer;
    });

    public static <S> boolean shouldModifyTint(S renderState) {
        if (renderState instanceof FabricRenderState) {
            FabricRenderState fabricRenderState = (FabricRenderState)renderState;
            Boolean isShadow = (Boolean)fabricRenderState.getData(IS_SHADOW_RENDER_STATE_DATA);
            return isShadow != null && isShadow != false;
        }
        return false;
    }

    public static int modifyTint(int original) {
        return class_9848.method_71346((float)(class_9848.method_65100((int)original) / 2.0f), (int)original);
    }

    public static class_1921 ensureTransparentLayer(class_1921 original) {
        if (original.method_60894()) {
            return original;
        }
        return TRANSPARENT_CONVERTER.apply(original);
    }

    public static void updateRenderState(class_1309 entity, class_10042 state) {
        if (NecromancyAttachments.isMarkedAsShadow((class_1297)entity)) {
            state.setData(IS_SHADOW_RENDER_STATE_DATA, (Object)true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class TransparentRenderPipeline
    extends RenderPipeline {
        protected TransparentRenderPipeline(RenderPipeline delegate) {
            super(delegate.getLocation(), delegate.getVertexShader(), delegate.getFragmentShader(), delegate.getShaderDefines(), delegate.getSamplers(), delegate.getUniforms(), Optional.of(BlendFunction.TRANSLUCENT), delegate.getDepthTestFunction(), delegate.getPolygonMode(), delegate.isCull(), delegate.isWriteColor(), delegate.isWriteAlpha(), delegate.isWriteDepth(), delegate.getColorLogic(), delegate.getVertexFormat(), delegate.getVertexFormatMode(), delegate.getDepthBiasScaleFactor(), delegate.getDepthBiasConstant(), delegate.getSortKey());
        }
    }
}

