/*
 * Decompiled with CFR 0.152.
 */
package cz.yorick.util;

import cz.yorick.NecromancersShadow;
import cz.yorick.data.MaxSoulEnergyGainConsumeEffect;
import cz.yorick.data.NecromancerData;
import cz.yorick.data.NecromancyAttachments;
import cz.yorick.data.ShadowData;
import cz.yorick.item.SculkEmeraldItem;
import cz.yorick.mixin.EntityAccessor;
import cz.yorick.util.Util;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_10124;
import net.minecraft.class_10134;
import net.minecraft.class_10179;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7706;
import net.minecraft.class_8942;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class EventHandlers {
    public static void init() {
        ServerLivingEntityEvents.AFTER_DEATH.register(EventHandlers::onEntityDeath);
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> NecromancerData.despawnShadows(handler.method_32311()));
        ServerLivingEntityEvents.MOB_CONVERSION.register(EventHandlers::onConversion);
        UseEntityCallback.EVENT.register(EventHandlers::onEntityInteract);
        DefaultItemComponentEvents.MODIFY.register(context -> context.modify(item -> item == class_1802.field_38746, EventHandlers::modifyEchoShardComponents));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40202).register(entries -> {
            entries.addAfter((class_1935)class_1802.field_8288, new class_1935[]{NecromancersShadow.SCULK_TOTEM});
            entries.addAfter((class_1935)NecromancersShadow.SCULK_TOTEM, new class_1935[]{NecromancersShadow.SCULK_EMERALD});
        });
    }

    private static void onEntityDeath(class_1309 killed, class_1282 source) {
        if (killed instanceof class_3222) {
            class_3222 player = (class_3222)killed;
            NecromancerData.despawnShadows(player);
            return;
        }
        if (killed instanceof class_1308) {
            class_3222 player;
            class_1308 mobEntity = (class_1308)killed;
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_3222 && Util.isHoldingTotem(player = (class_3222)class_12972) && !Util.isShadow((class_1297)killed)) {
                class_3218 world = player.method_51469();
                class_11362 nbt = class_11362.method_71459((class_8942)NecromancersShadow.ERROR_REPORTER, (class_7225.class_7874)mobEntity.method_56673());
                ((EntityAccessor)mobEntity).invokeWriteCustomData((class_11372)nbt);
                NecromancersShadow.SOUL_ENTITY_ENTITY_TYPE.method_5899(world, soulEntity -> soulEntity.setShadow(new ShadowData(mobEntity)), killed.method_24515(), class_3730.field_16461, false, false);
            }
        }
    }

    private static void onConversion(class_1308 previous, class_1308 converted, class_10179 context) {
        ShadowData.Instance shadowInstance = Util.getShadowInstance((class_1297)previous);
        if (shadowInstance == null) {
            return;
        }
        NecromancerData.convertShadow(shadowInstance, converted);
    }

    private static class_1269 onEntityInteract(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_239 hitResult) {
        class_1799 heldStack = player.method_5998(hand);
        class_1792 class_17922 = heldStack.method_7909();
        if (class_17922 instanceof SculkEmeraldItem) {
            class_1297 actualEntity;
            SculkEmeraldItem sculkEmeraldItem = (SculkEmeraldItem)class_17922;
            if (entity instanceof class_1508) {
                class_1508 dragonPart = (class_1508)entity;
                v0 = dragonPart.field_7007;
            } else {
                v0 = actualEntity = entity;
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ShadowData.Instance shadowInstance = Util.getShadowInstance(actualEntity);
                if (shadowInstance != null && shadowInstance.owner() == serverPlayer) {
                    class_1269.class_9860 success;
                    class_1269 itemResult = sculkEmeraldItem.onOwnedShadowUse(serverPlayer, heldStack, shadowInstance.shadow());
                    if (itemResult instanceof class_1269.class_9860 && (success = (class_1269.class_9860)itemResult).comp_2909() == class_1269.class_9861.field_52428) {
                        serverPlayer.method_23667(hand, true);
                    }
                    return itemResult;
                }
            } else if (NecromancyAttachments.isMarkedAsShadow(actualEntity)) {
                return class_1269.field_21466;
            }
        }
        return class_1269.field_5811;
    }

    private static void modifyEchoShardComponents(class_9323.class_9324 map, class_1792 item) {
        map.method_57840(class_9334.field_53964, (Object)class_10124.method_62850().method_62854((class_10134)new MaxSoulEnergyGainConsumeEffect(10)).method_62851());
    }
}

