/*
 * Decompiled with CFR 0.152.
 */
package inv.mamtak.inventorySee;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class InventorySee
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private final Set<UUID> lockedPlayers = new HashSet<UUID>();
    private File historyFile;
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.historyFile = new File(this.getDataFolder(), "history.log");
        for (String cmd : List.of("invsee", "invopen", "invlock")) {
            Objects.requireNonNull(this.getCommand(cmd)).setExecutor((CommandExecutor)this);
            this.getCommand(cmd).setTabCompleter((TabCompleter)this);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("InventorySee enabled.");
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (this.lockedPlayers.contains(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("locked-messages.interact")));
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        if (this.lockedPlayers.contains(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
            e.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("locked-messages.drop")));
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent e) {
        Player p;
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player && this.lockedPlayers.contains((p = (Player)livingEntity).getUniqueId())) {
            e.setCancelled(true);
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("locked-messages.pickup")));
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player p = (Player)sender;
        switch (cmd.getName().toLowerCase()) {
            case "invsee": {
                this.openInventory(p, args, false);
                break;
            }
            case "invopen": {
                this.openInventory(p, args, true);
                break;
            }
            case "invlock": {
                this.toggleLock(p, args);
            }
        }
        return true;
    }

    private void openInventory(Player staff, String[] args, boolean editable) {
        if (args.length < 1) {
            staff.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /" + (editable ? "invopen" : "invsee") + " <player>");
            return;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            staff.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return;
        }
        Inventory inv = Bukkit.createInventory((InventoryHolder)staff, (int)45, (String)(String.valueOf(ChatColor.DARK_GRAY) + target.getName() + (editable ? " [Edit]" : " [View]")));
        this.updateInventoryView(inv, target);
        staff.openInventory(inv);
        staff.setMetadata("invsee_target", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)(target.getName() + ":" + editable)));
        this.logAction(staff, target.getName(), editable ? "opened editable inventory" : "viewed inventory");
    }

    private void updateInventoryView(Inventory inv, Player target) {
        for (int i = 0; i < 36; ++i) {
            inv.setItem(i, target.getInventory().getItem(i));
        }
        inv.setItem(36, target.getInventory().getBoots());
        inv.setItem(37, target.getInventory().getLeggings());
        inv.setItem(38, target.getInventory().getChestplate());
        inv.setItem(39, target.getInventory().getHelmet());
        inv.setItem(40, target.getInventory().getItemInOffHand());
        ItemStack info = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta meta = info.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.AQUA) + target.getName() + "'s Info");
        meta.setLore(List.of(String.valueOf(ChatColor.GRAY) + "Health: " + String.valueOf(ChatColor.RED) + (int)target.getHealth() + "/" + (int)target.getMaxHealth(), String.valueOf(ChatColor.GRAY) + "Food: " + String.valueOf(ChatColor.GOLD) + target.getFoodLevel(), String.valueOf(ChatColor.GRAY) + "XP: " + String.valueOf(ChatColor.GREEN) + target.getLevel(), String.valueOf(ChatColor.GRAY) + "Gamemode: " + String.valueOf(ChatColor.YELLOW) + String.valueOf(target.getGameMode()), String.valueOf(ChatColor.GRAY) + "World: " + String.valueOf(ChatColor.AQUA) + target.getWorld().getName(), String.valueOf(ChatColor.GRAY) + "XYZ: " + String.valueOf(ChatColor.WHITE) + target.getLocation().getBlockX() + ", " + target.getLocation().getBlockY() + ", " + target.getLocation().getBlockZ()));
        info.setItemMeta(meta);
        inv.setItem(44, info);
    }

    private void toggleLock(Player staff, String[] args) {
        if (args.length < 1) {
            staff.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /invlock <player>");
            return;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            staff.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return;
        }
        if (this.lockedPlayers.remove(target.getUniqueId())) {
            staff.sendMessage(String.valueOf(ChatColor.GREEN) + "Unlocked " + target.getName() + "'s inventory.");
            target.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2705 Your inventory has been unlocked by staff.");
            this.logAction(staff, target.getName(), "unlocked inventory");
        } else {
            this.lockedPlayers.add(target.getUniqueId());
            staff.sendMessage(String.valueOf(ChatColor.RED) + "Locked " + target.getName() + "'s inventory.");
            target.sendMessage(String.valueOf(ChatColor.RED) + "\u26a0 Your inventory has been locked by staff.");
            this.logAction(staff, target.getName(), "locked inventory");
        }
    }

    @EventHandler
    public void onInventoryClick(final InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player staff = (Player)humanEntity;
        if (!staff.hasMetadata("invsee_target")) {
            return;
        }
        String[] meta = ((MetadataValue)staff.getMetadata("invsee_target").get(0)).asString().split(":");
        String targetName = meta[0];
        boolean editable = Boolean.parseBoolean(meta[1]);
        if (e.getSlot() == 44) {
            e.setCancelled(true);
            return;
        }
        final Player target = Bukkit.getPlayerExact((String)targetName);
        if (target == null) {
            e.setCancelled(true);
            return;
        }
        if (!editable) {
            e.setCancelled(true);
            return;
        }
        new BukkitRunnable(this){

            public void run() {
                for (int i = 0; i < 36; ++i) {
                    target.getInventory().setItem(i, e.getInventory().getItem(i));
                }
                target.getInventory().setBoots(e.getInventory().getItem(36));
                target.getInventory().setLeggings(e.getInventory().getItem(37));
                target.getInventory().setChestplate(e.getInventory().getItem(38));
                target.getInventory().setHelmet(e.getInventory().getItem(39));
                target.getInventory().setItemInOffHand(e.getInventory().getItem(40));
            }
        }.runTaskLater((Plugin)this, 1L);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        e.getPlayer().removeMetadata("invsee_target", (Plugin)this);
    }

    private void logAction(Player staff, String player, String action) {
        String time = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date());
        String formatted = String.valueOf(ChatColor.DARK_GRAY) + "\n\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n" + String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.YELLOW) + time + String.valueOf(ChatColor.GRAY) + "] " + String.valueOf(ChatColor.AQUA) + staff.getName() + String.valueOf(ChatColor.GRAY) + " " + action + " " + String.valueOf(ChatColor.YELLOW) + player + "\n" + String.valueOf(ChatColor.DARK_GRAY) + "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
        Bukkit.getConsoleSender().sendMessage(formatted);
        if (this.config.getBoolean("log-to-file")) {
            try (FileWriter fw = new FileWriter(this.historyFile, true);){
                fw.write("[" + time + "] " + staff.getName() + " " + action + " " + player + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (Player pl : Bukkit.getOnlinePlayers()) {
                list.add(pl.getName());
            }
            return list;
        }
        return Collections.emptyList();
    }
}

