/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium;

import com.disketaa.harmonium.Config;
import com.disketaa.harmonium.block.ModBlocks;
import com.disketaa.harmonium.entity.ModEntityArmorEvents;
import com.disketaa.harmonium.gui.ModCreativeTabItemRemover;
import com.disketaa.harmonium.gui.ModCreativeTabOrganizer;
import com.disketaa.harmonium.gui.ModCreativeTabs;
import com.disketaa.harmonium.item.ModArmorMaterials;
import com.disketaa.harmonium.item.ModItems;
import com.disketaa.harmonium.sound.ModSoundType;
import com.disketaa.harmonium.util.ModConditions;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="harmonium")
public class Harmonium {
    public static final String MOD_ID = "harmonium";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Harmonium(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(this::registerConditions);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(ModCreativeTabOrganizer::onBuildCreativeModeTabContents);
        modEventBus.addListener(ModCreativeTabItemRemover::onBuildCreativeModeTabContents);
        ModCreativeTabs.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModArmorMaterials.register(modEventBus);
        ModEntityArmorEvents.register();
        ModSoundType.register(modEventBus);
        ModConditions.register("config", ModConditions.ConfigValueCondition.CODEC);
    }

    private void registerConditions(RegisterEvent event) {
        event.register(NeoForgeRegistries.Keys.CONDITION_CODECS, helper -> {
            for (Map.Entry<String, MapCodec<? extends ICondition>> entry : ModConditions.SERIALIZERS.entrySet()) {
                ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)entry.getKey());
                helper.register(key, entry.getValue());
            }
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="harmonium", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

