/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium.block;

import com.disketaa.harmonium.block.custom.BronzeBulbBlock;
import com.disketaa.harmonium.block.custom.TinBulbBlock;
import com.disketaa.harmonium.block.custom.TinSoldierBlock;
import com.disketaa.harmonium.block.custom.UnreliableButtonBlock;
import com.disketaa.harmonium.item.ModItems;
import com.disketaa.harmonium.sound.ModBlockSetType;
import com.disketaa.harmonium.sound.ModSoundType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"harmonium");
    public static final DeferredBlock<Block> TIN_BLOCK = ModBlocks.registerMetalBlock("tin_block", Properties.GENERIC_TIN);
    public static final DeferredBlock<Block> CHISELED_TIN = ModBlocks.registerMetalBlock("chiseled_tin", Properties.GENERIC_TIN);
    public static final DeferredBlock<WaterloggedTransparentBlock> TIN_GRATE = ModBlocks.registerBlock("tin_grate", () -> ModBlocks.createGrate((Block)TIN_BLOCK.get(), (SoundType)ModSoundType.TIN_GRATE));
    public static final DeferredBlock<Block> CUT_TIN = ModBlocks.registerMetalBlock("cut_tin", Properties.GENERIC_TIN);
    public static final DeferredBlock<StairBlock> CUT_TIN_STAIRS = ModBlocks.registerBlock("cut_tin_stairs", () -> new StairBlock(((Block)CUT_TIN.get()).defaultBlockState(), Properties.GENERIC_TIN));
    public static final DeferredBlock<SlabBlock> CUT_TIN_SLAB = ModBlocks.registerBlock("cut_tin_slab", () -> new SlabBlock(Properties.GENERIC_TIN));
    public static final DeferredBlock<DoorBlock> TIN_DOOR = ModBlocks.registerBlock("tin_door", () -> new DoorBlock(ModBlockSetType.TIN, ModBlocks.createDoorProperties((Block)TIN_BLOCK.get())));
    public static final DeferredBlock<TrapDoorBlock> TIN_TRAPDOOR = ModBlocks.registerBlock("tin_trapdoor", () -> new TrapDoorBlock(ModBlockSetType.TIN, ModBlocks.createTrapdoorProperties((Block)TIN_BLOCK.get())));
    public static final DeferredBlock<TinBulbBlock> TIN_BULB = ModBlocks.registerMetalBulbBlock("tin_bulb", () -> new TinBulbBlock(Properties.TIN_BULB));
    public static final DeferredBlock<Block> BRONZE_BLOCK = ModBlocks.registerMetalBlock("bronze_block", Properties.GENERIC_BRONZE);
    public static final DeferredBlock<Block> CHISELED_BRONZE = ModBlocks.registerMetalBlock("chiseled_bronze", Properties.GENERIC_BRONZE);
    public static final DeferredBlock<WaterloggedTransparentBlock> BRONZE_GRATE = ModBlocks.registerBlock("bronze_grate", () -> ModBlocks.createGrate((Block)BRONZE_BLOCK.get(), (SoundType)ModSoundType.BRONZE_GRATE));
    public static final DeferredBlock<Block> CUT_BRONZE = ModBlocks.registerMetalBlock("cut_bronze", Properties.GENERIC_BRONZE);
    public static final DeferredBlock<StairBlock> CUT_BRONZE_STAIRS = ModBlocks.registerBlock("cut_bronze_stairs", () -> new StairBlock(((Block)CUT_BRONZE.get()).defaultBlockState(), Properties.GENERIC_BRONZE));
    public static final DeferredBlock<SlabBlock> CUT_BRONZE_SLAB = ModBlocks.registerBlock("cut_bronze_slab", () -> new SlabBlock(Properties.GENERIC_BRONZE));
    public static final DeferredBlock<DoorBlock> BRONZE_DOOR = ModBlocks.registerBlock("bronze_door", () -> new DoorBlock(ModBlockSetType.BRONZE, ModBlocks.createDoorProperties((Block)BRONZE_BLOCK.get())));
    public static final DeferredBlock<TrapDoorBlock> BRONZE_TRAPDOOR = ModBlocks.registerBlock("bronze_trapdoor", () -> new TrapDoorBlock(ModBlockSetType.BRONZE, ModBlocks.createTrapdoorProperties((Block)BRONZE_BLOCK.get())));
    public static final DeferredBlock<BronzeBulbBlock> BRONZE_BULB = ModBlocks.registerMetalBulbBlock("bronze_bulb", () -> new BronzeBulbBlock(Properties.BRONZE_BULB));
    public static final DeferredBlock<Block> TIN_ORE = ModBlocks.registerBlock("tin_ore", () -> new Block(Properties.ORE_STONE));
    public static final DeferredBlock<Block> DEEPSLATE_TIN_ORE = ModBlocks.registerBlock("deepslate_tin_ore", () -> new Block(Properties.ORE_DEEPSLATE));
    public static final DeferredBlock<Block> RAW_TIN_BLOCK = ModBlocks.registerBlock("raw_tin_block", () -> new Block(Properties.TIN_RAW));
    public static final DeferredBlock<Block> BRONZE_BLEND_BLOCK = ModBlocks.registerBlock("bronze_blend_block", () -> new Block(Properties.BRONZE_RAW));
    public static final DeferredBlock<TinSoldierBlock> TIN_SOLDIER = ModBlocks.registerBlock("tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.TERRACOTTA_WHITE)));
    public static final DeferredBlock<TinSoldierBlock> WHITE_TIN_SOLDIER = ModBlocks.registerBlock("white_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.SNOW)));
    public static final DeferredBlock<TinSoldierBlock> LIGHT_GRAY_TIN_SOLDIER = ModBlocks.registerBlock("light_gray_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_LIGHT_GRAY)));
    public static final DeferredBlock<TinSoldierBlock> GRAY_TIN_SOLDIER = ModBlocks.registerBlock("gray_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_GRAY)));
    public static final DeferredBlock<TinSoldierBlock> BLACK_TIN_SOLDIER = ModBlocks.registerBlock("black_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_BLACK)));
    public static final DeferredBlock<TinSoldierBlock> BROWN_TIN_SOLDIER = ModBlocks.registerBlock("brown_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_BROWN)));
    public static final DeferredBlock<TinSoldierBlock> RED_TIN_SOLDIER = ModBlocks.registerBlock("red_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_RED)));
    public static final DeferredBlock<TinSoldierBlock> ORANGE_TIN_SOLDIER = ModBlocks.registerBlock("orange_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_ORANGE)));
    public static final DeferredBlock<TinSoldierBlock> YELLOW_TIN_SOLDIER = ModBlocks.registerBlock("yellow_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_YELLOW)));
    public static final DeferredBlock<TinSoldierBlock> LIME_TIN_SOLDIER = ModBlocks.registerBlock("lime_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_LIGHT_GREEN)));
    public static final DeferredBlock<TinSoldierBlock> GREEN_TIN_SOLDIER = ModBlocks.registerBlock("green_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_GREEN)));
    public static final DeferredBlock<TinSoldierBlock> CYAN_TIN_SOLDIER = ModBlocks.registerBlock("cyan_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_CYAN)));
    public static final DeferredBlock<TinSoldierBlock> LIGHT_BLUE_TIN_SOLDIER = ModBlocks.registerBlock("light_blue_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_LIGHT_BLUE)));
    public static final DeferredBlock<TinSoldierBlock> BLUE_TIN_SOLDIER = ModBlocks.registerBlock("blue_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_BLUE)));
    public static final DeferredBlock<TinSoldierBlock> PURPLE_TIN_SOLDIER = ModBlocks.registerBlock("purple_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_PURPLE)));
    public static final DeferredBlock<TinSoldierBlock> MAGENTA_TIN_SOLDIER = ModBlocks.registerBlock("magenta_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_MAGENTA)));
    public static final DeferredBlock<TinSoldierBlock> PINK_TIN_SOLDIER = ModBlocks.registerBlock("pink_tin_soldier", () -> new TinSoldierBlock(Properties.TIN_SOLDIER.mapColor(MapColor.COLOR_PINK)));
    public static DeferredBlock<ButtonBlock> TIN_BUTTON = null;
    public static DeferredBlock<ButtonBlock> BRONZE_BUTTON = null;

    private static DeferredBlock<Block> registerMetalBlock(String name, BlockBehaviour.Properties properties) {
        return ModBlocks.registerBlock(name, () -> new Block(properties));
    }

    private static <T extends Block> DeferredBlock<T> registerMetalBulbBlock(String name, Supplier<T> blockSupplier) {
        return ModBlocks.registerBlock(name, blockSupplier);
    }

    private static WaterloggedTransparentBlock createGrate(Block baseBlock, SoundType sound) {
        return new WaterloggedTransparentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).sound(sound).noOcclusion().isRedstoneConductor((state, level, pos) -> false).isSuffocating((state, level, pos) -> false).isViewBlocking((state, level, pos) -> false).isValidSpawn((state, level, pos, type) -> false));
    }

    private static BlockBehaviour.Properties createDoorProperties(Block baseBlock) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).noOcclusion().pushReaction(PushReaction.DESTROY);
    }

    private static BlockBehaviour.Properties createTrapdoorProperties(Block baseBlock) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).noOcclusion().isValidSpawn(Blocks::never);
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> blockSupplier) {
        DeferredBlock block = BLOCKS.register(name, blockSupplier);
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public static List<Item> getAllBlockItems() {
        ArrayList<Item> blockItems = new ArrayList<Item>();
        for (DeferredHolder block : BLOCKS.getEntries()) {
            blockItems.add(((Block)block.get()).asItem());
        }
        return blockItems;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        if (ModList.get().isLoaded("friendsandfoes")) {
            TIN_BUTTON = ModBlocks.registerBlock("tin_button", () -> new UnreliableButtonBlock(ModBlockSetType.TIN, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).sound((SoundType)ModSoundType.TIN).strength(0.5f, 0.5f).noCollission()));
            BRONZE_BUTTON = ModBlocks.registerBlock("bronze_button", () -> new ButtonBlock(ModBlockSetType.BRONZE, 40, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).sound((SoundType)ModSoundType.TIN).strength(0.5f, 0.5f).noCollission()));
        }
    }

    private static final class Properties {
        static final BlockBehaviour.Properties GENERIC_TIN = Properties.createMetalProperties(MapColor.TERRACOTTA_WHITE, (SoundType)ModSoundType.TIN, 2.0f);
        static final BlockBehaviour.Properties GENERIC_BRONZE = Properties.createMetalProperties(MapColor.TERRACOTTA_YELLOW, (SoundType)ModSoundType.BRONZE, 4.0f);
        static final BlockBehaviour.Properties TIN_BULB = Properties.createBulbProperties(MapColor.TERRACOTTA_WHITE, (SoundType)ModSoundType.TIN_BULB, state -> (Integer)state.getValue((Property)TinBulbBlock.LIGHT_LEVEL), 2.0f);
        static final BlockBehaviour.Properties BRONZE_BULB = Properties.createBulbProperties(MapColor.TERRACOTTA_ORANGE, (SoundType)ModSoundType.BRONZE_BULB, state -> (Boolean)state.getValue((Property)BronzeBulbBlock.LIT) != false ? (Integer)state.getValue((Property)BronzeBulbBlock.LIGHT_LEVEL) : 0, 4.0f);
        static final BlockBehaviour.Properties TIN_SOLDIER = BlockBehaviour.Properties.of().sound((SoundType)ModSoundType.TIN_SOLDIER).noOcclusion().strength(0.1f, 0.1f).pushReaction(PushReaction.DESTROY);
        static final BlockBehaviour.Properties ORE_STONE = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f);
        static final BlockBehaviour.Properties ORE_DEEPSLATE = BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).sound(SoundType.DEEPSLATE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(4.5f, 3.0f);
        static final BlockBehaviour.Properties TIN_RAW = BlockBehaviour.Properties.of().mapColor(MapColor.RAW_IRON).requiresCorrectToolForDrops().strength(4.0f, 6.0f);
        static final BlockBehaviour.Properties BRONZE_RAW = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).requiresCorrectToolForDrops().strength(5.0f, 6.0f);

        private Properties() {
        }

        private static BlockBehaviour.Properties createMetalProperties(MapColor color, SoundType sound, float strength) {
            return BlockBehaviour.Properties.of().mapColor(color).sound(sound).requiresCorrectToolForDrops().strength(strength, 6.0f);
        }

        private static BlockBehaviour.Properties createBulbProperties(MapColor color, SoundType sound, ToIntFunction<BlockState> lightLevel, float strength) {
            return BlockBehaviour.Properties.of().mapColor(color).sound(sound).isRedstoneConductor((state, level, pos) -> false).lightLevel(lightLevel).requiresCorrectToolForDrops().strength(strength, 6.0f);
        }
    }
}

