/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium.block.custom;

import com.disketaa.harmonium.sound.ModSoundType;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BronzeBulbBlock
extends Block {
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.create((String)"light_level", (int)0, (int)15);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public BronzeBulbBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIGHT_LEVEL, LIT, POWERED});
    }

    public void onPlace(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void neighborChanged(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        this.updateLightState(state, (Level)level, pos);
    }

    private void updateLightState(BlockState state, Level level, BlockPos pos) {
        boolean hasPower = level.hasNeighborSignal(pos);
        int redstonePower = level.getBestNeighborSignal(pos);
        boolean wasPowered = (Boolean)state.getValue((Property)POWERED);
        BlockState newState = state;
        if (hasPower != wasPowered) {
            newState = (BlockState)newState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower));
            if (hasPower) {
                level.playSound(null, pos, (Boolean)(newState = (BlockState)newState.cycle((Property)LIT)).getValue((Property)LIT) != false ? (SoundEvent)ModSoundType.BRONZE_BULB_TURN_ON.get() : (SoundEvent)ModSoundType.BRONZE_BULB_TURN_OFF.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (((Boolean)newState.getValue((Property)LIT)).booleanValue()) {
            if (hasPower) {
                int newLight = Math.max(1, Math.min(15, redstonePower));
                newState = (BlockState)newState.setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(newLight));
            }
        } else {
            newState = (BlockState)newState.setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0));
        }
        if (!state.equals(newState)) {
            level.setBlock(pos, newState, 2);
        }
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? (Integer)state.getValue((Property)LIGHT_LEVEL) : 0;
    }

    public boolean isSignalSource(@NotNull BlockState state) {
        return false;
    }
}

