/*
 * Decompiled with CFR 0.152.
 */
package com.disketaa.harmonium.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class BulbBlock
extends Block {
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.create((String)"light_level", (int)0, (int)15);

    public BulbBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void updateLightLevel(BlockState state, Level level, BlockPos pos) {
        int currentLight;
        int redstonePower = level.getBestNeighborSignal(pos);
        if (redstonePower != (currentLight = ((Integer)state.getValue((Property)LIGHT_LEVEL)).intValue())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(redstonePower)), 3);
        }
    }

    public boolean isSignalSource(@NotNull BlockState state) {
        return false;
    }

    public int getSignal(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return 0;
    }

    protected abstract void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var1);
}

